/*
 * Decompiled with CFR 0.152.
 */
package net.wirelabs.jmaps.map.downloader;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import net.wirelabs.jmaps.map.MapViewer;
import net.wirelabs.jmaps.map.downloader.TileProvider;
import net.wirelabs.jmaps.map.downloader.TileProviderThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadingTileProvider
implements TileProvider {
    private static final Logger log = LoggerFactory.getLogger(DownloadingTileProvider.class);
    private final HttpClient httpClient;
    private final List<String> tilesLoading = new CopyOnWriteArrayList<String>();
    private final MapViewer mapViewer;
    private ExecutorService executorService;

    public DownloadingTileProvider(MapViewer mapViewer) {
        this.mapViewer = mapViewer;
        this.httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofSeconds(20L)).build();
    }

    private ExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = Executors.newFixedThreadPool(this.mapViewer.getTilerThreads(), new TileProviderThreadFactory());
        }
        return this.executorService;
    }

    void download(String tileUrl) {
        log.debug("Getting from: {}", (Object)tileUrl);
        HttpRequest r = HttpRequest.newBuilder().uri(URI.create(tileUrl)).header("User-Agent", this.mapViewer.getUserAgent()).build();
        try {
            HttpResponse<InputStream> response = this.httpClient.send(r, HttpResponse.BodyHandlers.ofInputStream());
            if (response.statusCode() == 200) {
                this.readAndCacheImage(tileUrl, response);
            }
        }
        catch (Exception e) {
            log.debug("Could not download {} - {} : {}", tileUrl, e.getClass().getSimpleName(), e.getMessage());
        }
        catch (OutOfMemoryError e) {
            log.error("DANG! Local memory cache run out of memory");
            log.error("Pruning memory cache...");
            this.mapViewer.getPrimaryTileCache().clear();
        }
        this.tilesLoading.remove(tileUrl);
    }

    private void readAndCacheImage(String tileUrl, HttpResponse<InputStream> response) throws IOException {
        InputStream inputStream = response.body();
        Optional<BufferedImage> image = Optional.ofNullable(ImageIO.read(inputStream));
        if (image.isPresent()) {
            this.mapViewer.getPrimaryTileCache().put(tileUrl, image.get());
            if (this.secondaryCacheEnabled()) {
                this.mapViewer.getSecondaryTileCache().put(tileUrl, image.get());
            }
            this.tilesLoading.remove(tileUrl);
            this.mapViewer.repaint();
        }
    }

    @Override
    public BufferedImage getTile(String url) {
        Optional<BufferedImage> image;
        Optional<BufferedImage> img = Optional.ofNullable(this.mapViewer.getPrimaryTileCache().get(url));
        if (img.isPresent()) {
            return img.get();
        }
        if (this.secondaryCacheEnabled() && (image = Optional.ofNullable(this.mapViewer.getSecondaryTileCache().get(url))).isPresent() && !this.mapViewer.getSecondaryTileCache().keyExpired(url)) {
            this.mapViewer.getPrimaryTileCache().put(url, image.get());
            return image.get();
        }
        if (!this.tilesLoading.contains(url)) {
            this.tilesLoading.add(url);
            this.getExecutorService().submit(() -> this.download(url));
        }
        return null;
    }

    private boolean secondaryCacheEnabled() {
        return this.mapViewer.getSecondaryTileCache() != null;
    }
}

