/*
 * Decompiled with CFR 0.152.
 */
package net.wirelabs.jmaps.map.cache;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import javax.imageio.ImageIO;
import net.wirelabs.jmaps.map.cache.BaseCache;
import net.wirelabs.jmaps.map.cache.Cache;
import net.wirelabs.jmaps.map.utils.UrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryBasedCache
extends BaseCache
implements Cache<String, BufferedImage> {
    private static final Logger log = LoggerFactory.getLogger(DirectoryBasedCache.class);

    public DirectoryBasedCache() {
    }

    public DirectoryBasedCache(Path cacheDir, Duration cacheTimeout) {
        super(cacheDir, cacheTimeout);
    }

    @Override
    public BufferedImage get(String key) {
        return this.getImage(key);
    }

    @Override
    public void put(String key, BufferedImage b) {
        this.putImage(key, b);
    }

    private BufferedImage getImage(String key) {
        try {
            Path filePath = this.getLocalFile(key);
            if (!filePath.toFile().exists()) {
                return null;
            }
            return ImageIO.read(Files.newInputStream(filePath, new OpenOption[0]));
        }
        catch (IOException e) {
            log.warn("File cache get failed for {}-{}", (Object)key, (Object)e.getMessage());
            return null;
        }
    }

    private void putImage(String key, BufferedImage b) {
        try {
            Path filePath = this.getLocalFile(key);
            if (!filePath.toFile().exists()) {
                Files.createDirectories(filePath, new FileAttribute[0]);
            }
            ImageIO.write((RenderedImage)b, "png", filePath.toFile());
        }
        catch (IOException ex) {
            log.warn("File cache put failed for {}-{}", (Object)key, (Object)ex.getMessage());
        }
    }

    @Override
    public boolean keyExpired(String key) {
        return this.keyExpired(this.getTimestampFromFile(key));
    }

    private long getTimestampFromFile(String key) {
        try {
            return Files.getLastModifiedTime(this.getLocalFile(key), new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    private Path getLocalFile(String remoteUri) throws IOException {
        return Path.of(this.getBaseDir().toString(), UrlUtils.urlToStringPath(remoteUri));
    }
}

