/*
 * Decompiled with CFR 0.152.
 */
package net.wirelabs.jmaps.map.cache;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import net.wirelabs.jmaps.map.Defaults;
import net.wirelabs.jmaps.map.cache.BaseCache;
import net.wirelabs.jmaps.map.cache.Cache;
import net.wirelabs.jmaps.map.utils.ImageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBCache
extends BaseCache
implements Cache<String, BufferedImage> {
    private static final Logger log = LoggerFactory.getLogger(DBCache.class);
    private static final String CONNECTION_TEMPLATE = "jdbc:sqlite:%s/cache.db";
    private static final String CREATE_TABLE_SQL = "CREATE TABLE TILECACHE (tileUrl VARCHAR(1024) PRIMARY KEY,tileImg BLOB,timeStamp BIGINT)";
    private static final String GET_TEMPLATE_SQL = "select TILEIMG from TILECACHE where TILEURL='%s'";
    private static final String PUT_TEMPLATE_SQL = "INSERT INTO TILECACHE VALUES('%s', ?, ?)";
    private static final String UPDATE_TEMPLATE_SQL = "UPDATE TILECACHE set TILEIMG=?,TIMESTAMP=? WHERE TILEURL='%s'";
    private static final String GET_TIMESTAMP_TEMPLATE_SQL = "select TIMESTAMP from TILECACHE where TILEURL='%s'";
    private static final String COUNT_TEMPLATE_SQL = "select count (*) from TILECACHE where TILEURL='%s'";

    public DBCache() {
        super(Defaults.DEFAULT_TILE_CACHE_DB, Defaults.DEFAULT_CACHE_TIMEOUT);
        this.createDatabaseIfNotExists();
    }

    public DBCache(Path dbBaseDir, Duration cacheTimeout) {
        super(dbBaseDir, cacheTimeout);
        this.createDatabaseIfNotExists();
    }

    @Override
    public BufferedImage get(String key) {
        return this.getImage(key);
    }

    @Override
    public void put(String key, BufferedImage value) {
        this.putImage(key, value);
    }

    @Override
    public boolean keyExpired(String key) {
        return this.keyExpired(this.getTimestampFromDB(key));
    }

    Connection getConnection() throws SQLException {
        return DriverManager.getConnection(String.format(CONNECTION_TEMPLATE, this.getBaseDir()));
    }

    private void createDatabaseIfNotExists() {
        try {
            if (!this.getBaseDir().toFile().exists()) {
                Files.createDirectory(this.getBaseDir(), new FileAttribute[0]);
            }
            try (Connection dbConnection = this.getConnection();
                 Statement smt = dbConnection.createStatement();){
                if (!this.cacheTableExists(dbConnection)) {
                    smt.execute(CREATE_TABLE_SQL);
                }
                log.info("Connected and initialized: {}", (Object)dbConnection.getMetaData().getURL());
            }
        }
        catch (IOException | SQLException e) {
            log.info("Could not create connection!");
        }
    }

    private boolean cacheTableExists(Connection dbConnection) throws SQLException {
        if (dbConnection != null) {
            DatabaseMetaData metaData = dbConnection.getMetaData();
            try (ResultSet rs = metaData.getTables(null, null, "TILECACHE", null);){
                boolean bl = rs.next();
                return bl;
            }
        }
        return false;
    }

    private void putImage(String key, BufferedImage value) {
        try {
            byte[] imgbytes = ImageUtils.imageToBytes(value);
            String sqlCmd = !this.entryExists(key) ? String.format(PUT_TEMPLATE_SQL, key) : String.format(UPDATE_TEMPLATE_SQL, key);
            try (Connection connection = this.getConnection();
                 PreparedStatement ps = connection.prepareStatement(sqlCmd);){
                ps.setBytes(1, imgbytes);
                ps.setLong(2, System.currentTimeMillis());
                ps.execute();
            }
        }
        catch (IOException | SQLException e) {
            log.warn("Cache put failed! {}", (Object)e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BufferedImage getImage(String key) {
        String query = String.format(GET_TEMPLATE_SQL, key);
        try (Connection connection = this.getConnection();
             Statement stmt = connection.createStatement();
             ResultSet rs = stmt.executeQuery(query);){
            if (!rs.next()) return null;
            byte[] is = rs.getBytes(1);
            BufferedImage bufferedImage = ImageUtils.imageFromBytes(is);
            return bufferedImage;
        }
        catch (IOException | SQLException e) {
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    private long getTimestampFromDB(String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    boolean entryExists(String key) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

