/*
 * Decompiled with CFR 0.152.
 */
package net.wirelabs.jmaps.map.cache;

import java.nio.file.Path;
import java.time.Duration;
import net.wirelabs.jmaps.map.Defaults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCache {
    private static final Logger log = LoggerFactory.getLogger(BaseCache.class);
    private final Path baseDir;
    private Duration cacheTimeout;

    protected BaseCache() {
        this(Defaults.DEFAULT_TILE_CACHE_DIR, Defaults.DEFAULT_CACHE_TIMEOUT);
    }

    protected BaseCache(Path baseDir, Duration cacheTimeout) {
        this.baseDir = baseDir;
        this.cacheTimeout = cacheTimeout;
        log.info("Secondary Tile Cache: {}, location: {}", (Object)this.getClass().getSimpleName(), (Object)this.getBaseDir());
        if (this.isCacheTimeoutEnabled()) {
            String expirationTimeMsg = this.prepareExpirationMessage(cacheTimeout);
            log.info("Cache expiration checking enabled! Tiles will be re-downloaded every: {}", (Object)expirationTimeMsg);
        } else {
            log.info("Cache expiration checking disabled. Stored tiles won't ever be re-downloaded");
        }
    }

    private String prepareExpirationMessage(Duration cacheTimeout) {
        StringBuilder builder = new StringBuilder();
        long days = cacheTimeout.toDaysPart();
        long hours = cacheTimeout.toHoursPart();
        long minutes = cacheTimeout.toMinutesPart();
        long seconds = cacheTimeout.toSecondsPart();
        if (days > 0L) {
            builder.append(days).append(" days");
        }
        if (hours > 0L) {
            builder.append(hours).append(" hours");
        }
        if (minutes > 0L) {
            builder.append(minutes).append(" minutes");
        }
        if (seconds > 0L) {
            builder.append(seconds).append(" seconds");
        }
        return builder.toString();
    }

    protected boolean isCacheTimeoutEnabled() {
        return !this.cacheTimeout.isZero();
    }

    protected boolean keyExpired(long timestamp) {
        boolean timeExpired = timestamp != 0L && System.currentTimeMillis() > timestamp + this.getCacheTimeout().toMillis();
        return this.isCacheTimeoutEnabled() && timeExpired;
    }

    public Path getBaseDir() {
        return this.baseDir;
    }

    public Duration getCacheTimeout() {
        return this.cacheTimeout;
    }

    public void setCacheTimeout(Duration cacheTimeout) {
        this.cacheTimeout = cacheTimeout;
    }
}

