/*
 * Decompiled with CFR 0.152.
 */
package net.wirelabs.jmaps.map;

import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.util.Optional;
import net.wirelabs.jmaps.map.Defaults;
import net.wirelabs.jmaps.map.MapViewer;
import net.wirelabs.jmaps.map.TileDebugger;
import net.wirelabs.jmaps.map.downloader.TileProvider;
import net.wirelabs.jmaps.map.layer.Layer;
import net.wirelabs.jmaps.map.painters.CurrentPositionPainter;
import net.wirelabs.jmaps.map.painters.MapAttributionPainter;
import net.wirelabs.jmaps.map.painters.Painter;
import net.wirelabs.jmaps.map.painters.TextPrinter;

public class MapRenderer {
    private final MapViewer mapViewer;
    private final TileProvider tileProvider;
    private final TextPrinter coordinatePrinter;
    private final TextPrinter mapAttributionPrinter;
    private VolatileImage tempImage;
    private Graphics2D tempImageGraphics;

    public MapRenderer(MapViewer mapViewer, TileProvider tileProvider) {
        this.mapViewer = mapViewer;
        this.tileProvider = tileProvider;
        this.coordinatePrinter = new CurrentPositionPainter();
        this.mapAttributionPrinter = new MapAttributionPainter();
    }

    public void renderMap(Graphics graphicsContext) {
        if (this.mapViewer.getCurrentMap().layersPresent()) {
            this.renderTiles(graphicsContext, this.mapViewer.getZoom(), this.mapViewer.getTopLeftCornerPoint());
            this.renderUserOverlays((Graphics2D)graphicsContext);
            this.renderDefaultOverlays((Graphics2D)graphicsContext);
        }
    }

    private void renderTiles(Graphics g, int zoom, Point topLeftCorner) {
        int tileSize = this.mapViewer.getCurrentMap().getBaseLayer().getTileSize();
        this.createOutputCanvas(tileSize);
        int viewportTilesWidth = this.mapViewer.getWidth() / tileSize + 2;
        int viewportTilesHeight = this.mapViewer.getHeight() / tileSize + 2;
        int numTilesX = (int)Math.floor(topLeftCorner.getX() / (double)tileSize);
        int numTilesY = (int)Math.floor(topLeftCorner.getY() / (double)tileSize);
        for (int x = 0; x <= viewportTilesWidth; ++x) {
            for (int y = 0; y <= viewportTilesHeight; ++y) {
                int tileX = x + numTilesX;
                int tileY = y + numTilesY;
                int px = tileX * tileSize - topLeftCorner.x;
                int py = tileY * tileSize - topLeftCorner.y;
                Rectangle currentTileBounds = new Rectangle(px, py, tileSize, tileSize);
                if (!g.getClipBounds().intersects(currentTileBounds)) continue;
                if (this.isTileLegal(tileX, tileY, zoom)) {
                    this.renderTile(g, zoom, tileX, tileY, px, py);
                }
                if (!this.mapViewer.isDeveloperMode()) continue;
                TileDebugger.drawTileDebugInfo(g, tileSize, tileX, tileY, px, py, zoom);
            }
        }
    }

    private boolean isTileLegal(int tileX, int tileY, int zoom) {
        Dimension mapSize = this.mapViewer.getCurrentMap().getBaseLayer().getSizeInTiles(zoom);
        return tileX >= 0 && tileY >= 0 && tileX < mapSize.width && tileY < mapSize.height;
    }

    private void createOutputCanvas(int tileSize) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration gc = ge.getDefaultScreenDevice().getDefaultConfiguration();
        if (this.tempImage == null || this.tempImage.getHeight() != tileSize || this.tempImage.getWidth() != tileSize) {
            this.tempImage = gc.createCompatibleVolatileImage(tileSize, tileSize, 3);
            this.tempImageGraphics = this.tempImage.createGraphics();
        }
    }

    private void renderTile(Graphics g, int zoom, int tileX, int tileY, int px, int py) {
        this.tempImageGraphics.setBackground(Defaults.EMPTY_FILL_COLOR);
        this.tempImageGraphics.clearRect(0, 0, this.tempImage.getWidth(), this.tempImage.getHeight());
        for (Layer layer : this.mapViewer.getCurrentMap().getEnabledLayers()) {
            String tileUrl = layer.createTileUrl(tileX, tileY, zoom + layer.getZoomOffset());
            Optional<BufferedImage> b = Optional.ofNullable(this.tileProvider.getTile(tileUrl));
            if (!b.isPresent()) continue;
            AlphaComposite alpha = AlphaComposite.getInstance(3, Math.min(layer.getOpacity(), 1.0f));
            this.tempImageGraphics.setComposite(alpha);
            this.tempImageGraphics.drawImage((Image)b.get(), 0, 0, null);
        }
        g.drawImage(this.tempImage, px, py, null);
    }

    private void renderUserOverlays(Graphics2D graphics2D) {
        for (Painter<MapViewer> painter : this.mapViewer.getUserOverlays()) {
            painter.doPaint(graphics2D, this.mapViewer, this.mapViewer.getWidth(), this.mapViewer.getHeight());
        }
    }

    private void renderDefaultOverlays(Graphics2D graphics) {
        if (this.mapViewer.isShowCoordinates()) {
            this.coordinatePrinter.print(graphics, this.mapViewer, this.mapViewer.getWidth(), this.mapViewer.getHeight());
        }
        if (this.mapViewer.isShowAttribution()) {
            this.mapAttributionPrinter.print(graphics, this.mapViewer, this.mapViewer.getWidth(), this.mapViewer.getHeight());
        }
    }
}

