/*
 * Decompiled with CFR 0.152.
 */
package net.wirelabs.jmaps.map;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class MapFileValidator {
    private static final Logger log = LoggerFactory.getLogger(MapFileValidator.class);
    private Validator validator;

    public MapFileValidator() {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            String fileUrl = Objects.requireNonNull(this.getClass().getClassLoader().getResource("schemas/mapDefinition.xsd")).getFile();
            StreamSource schemaFile = new StreamSource(fileUrl);
            this.validator = factory.newSchema(schemaFile).newValidator();
        }
        catch (NullPointerException | SAXException e) {
            log.error("Map validator failed to start, cause: {}", (Object)e.getMessage());
        }
    }

    public boolean validateMapFile(File mapDefinitionFile) {
        try {
            this.validator.validate(new StreamSource(mapDefinitionFile));
            return true;
        }
        catch (SAXException e) {
            log.error("XML of map file {} does not conform with map file schema", (Object)mapDefinitionFile.getName());
            log.error("The cause of non-conformity is: {}", (Object)e.getMessage());
            return false;
        }
        catch (IOException e) {
            log.error("IO Exception while parsing XML: {}", (Object)e.getMessage());
            return false;
        }
    }
}

