/*
 * Decompiled with CFR 0.152.
 */
package net.wirelabs.jmaps.example.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.List;
import net.wirelabs.jmaps.map.MapViewer;
import net.wirelabs.jmaps.map.geo.Coordinate;
import net.wirelabs.jmaps.map.painters.Painter;

public class RoutePainter
extends Painter<MapViewer> {
    private Color routeColor = Color.RED;

    public void setColor(Color color) {
        this.routeColor = color;
    }

    @Override
    public void doPaint(Graphics2D graphics, MapViewer mapViewer, int width, int height) {
        if (!this.getObjects().isEmpty()) {
            Stroke s = graphics.getStroke();
            Color color = graphics.getColor();
            graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            graphics.setColor(this.routeColor);
            graphics.setStroke(new BasicStroke(3.0f, 1, 1));
            this.drawRoute(graphics, mapViewer);
            graphics.setColor(color);
            graphics.setStroke(s);
        }
    }

    public void clearRoute() {
        this.getObjects().clear();
    }

    private void drawRoute(Graphics2D graphicsContext, MapViewer map) {
        int lastX = 0;
        int lastY = 0;
        boolean firstPoint = true;
        for (Coordinate gp : this.getObjects()) {
            Point2D pt = map.getCurrentMap().getBaseLayer().latLonToPixel(gp, map.getZoom());
            pt.setLocation(pt.getX() - (double)map.getTopLeftCornerPoint().x, pt.getY() - (double)map.getTopLeftCornerPoint().y);
            if (firstPoint) {
                firstPoint = false;
            } else {
                graphicsContext.drawLine(lastX, lastY, (int)pt.getX(), (int)pt.getY());
            }
            lastX = (int)pt.getX();
            lastY = (int)pt.getY();
        }
    }

    public void setRoute(List<Coordinate> route) {
        this.setObjects(route);
    }
}

