/*
 * Decompiled with CFR 0.152.
 */
package net.wirelabs.jmaps.map.painters;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import net.wirelabs.jmaps.map.MapViewer;
import net.wirelabs.jmaps.map.painters.ScreenPosition;

public abstract class TextPrinter {
    protected ScreenPosition position;
    protected Font font = new Font("Dialog", 1, 10);
    protected Color backgroundColor = Color.WHITE;
    protected Color fontColor = Color.BLACK;
    protected boolean framed = true;
    protected int margin = 2;

    public abstract void print(Graphics2D var1, MapViewer var2, int var3, int var4);

    protected Point setStartPoint(int width, int height, int textWidth, int textHeight) {
        int x = 0;
        int y = 0;
        switch (this.position) {
            case TOP_LEFT: {
                y = this.margin;
                x = this.margin;
                return new Point(x, y);
            }
            case TOP_RIGHT: {
                y = this.margin;
                x = width - textWidth - this.margin;
                return new Point(x, y);
            }
            case BOTTOM_LEFT: {
                y = height - textHeight - this.margin;
                x = this.margin;
                return new Point(x, y);
            }
            case BOTTOM_RIGHT: {
                y = height - textHeight - this.margin;
                x = width - textWidth - this.margin;
                return new Point(x, y);
            }
        }
        return new Point(0, 0);
    }

    protected void printText(Graphics2D graphics, int width, int height, String attributionText) {
        graphics.setFont(this.font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle2D textBounds = fontMetrics.getStringBounds(attributionText, graphics);
        int attributionWidth = (int)textBounds.getWidth();
        int attributionHeight = (int)textBounds.getHeight();
        Point startPoint = this.setStartPoint(width, height, attributionWidth, attributionHeight);
        if (this.framed) {
            graphics.setColor(this.backgroundColor);
            graphics.fillRect(startPoint.x, startPoint.y, attributionWidth, attributionHeight);
            graphics.setColor(Color.BLACK);
            graphics.drawRect(startPoint.x, startPoint.y, attributionWidth, attributionHeight);
        }
        graphics.setColor(this.fontColor);
        graphics.drawString(attributionText, startPoint.x, startPoint.y + fontMetrics.getAscent());
    }

    public void setPosition(ScreenPosition position) {
        this.position = position;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setFontColor(Color fontColor) {
        this.fontColor = fontColor;
    }

    public void setFramed(boolean framed) {
        this.framed = framed;
    }

    public void setMargin(int margin) {
        this.margin = margin;
    }
}

