/*
 * Decompiled with CFR 0.152.
 */
package net.wirelabs.jmaps.map.layer;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.Optional;
import net.opengis.ows.x11.DatasetDescriptionSummaryBaseType;
import net.opengis.wmts.x10.CapabilitiesDocument;
import net.opengis.wmts.x10.TileMatrixSetDocument;
import net.wirelabs.jmaps.map.geo.GeoUtils;
import net.wirelabs.jmaps.map.layer.Layer;
import net.wirelabs.jmaps.map.readers.WMTSCapReader;
import net.wirelabs.jmaps.model.map.LayerDocument;
import okhttp3.HttpUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WMTSLayer
extends Layer {
    private static final Logger log = LoggerFactory.getLogger(WMTSLayer.class);
    private static final String DEFAULT_GET_CAPABILITIES_PATH = "?service=WMTS&request=GetCapabilities";
    private final CapabilitiesDocument.Capabilities capabilities = WMTSCapReader.loadCapabilities(this.getCapabilitiesUrl());
    private TileMatrixSetDocument.TileMatrixSet tms;
    protected String tmsName;
    protected String layerName;

    public WMTSLayer(LayerDocument.Layer layerDefinition) {
        super(layerDefinition);
        this.tmsName = layerDefinition.getTileMatrixSet();
        this.layerName = layerDefinition.getWmtsLayer();
        if (this.isEmpty(this.tmsName) || this.tmsNotExistent(this.tmsName)) {
            this.tmsName = this.capabilities.getContents().getTileMatrixSetList().get(0).getIdentifier().getStringValue();
        }
        if (this.isEmpty(this.layerName) || this.layerNotExistent(this.layerName)) {
            this.layerName = this.capabilities.getContents().getDatasetDescriptionSummaryList().get(0).getIdentifier().getStringValue();
        }
        this.findTileMatrixSetById(this.tmsName).ifPresentOrElse(tileMatrixSet -> {
            this.tms = tileMatrixSet;
            if (this.isEmpty(layerDefinition.getCrs())) {
                String crsName = GeoUtils.parseCrsUrn(tileMatrixSet.getSupportedCRS());
                this.setProjection(crsName);
                this.crs = crsName;
            }
            this.setMaxZoom(tileMatrixSet.getTileMatrixList().size() - 1);
            this.setTileSize(tileMatrixSet.getTileMatrixList().get(0).getTileWidth().intValue());
        }, () -> {
            log.warn("Cannot parse/setup layer " + layerDefinition.getName());
            log.warn("Setting global best-effort defaults");
            this.setMaxZoom(18);
            this.setTileSize(256);
            this.setCrs("EPSG:3857");
        });
    }

    private Optional<TileMatrixSetDocument.TileMatrixSet> findTileMatrixSetById(String id) {
        return this.capabilities.getContents().getTileMatrixSetList().stream().filter(x -> x.getIdentifier().getStringValue().equals(id)).findFirst();
    }

    private Optional<DatasetDescriptionSummaryBaseType> findLayerById(String id) {
        return this.capabilities.getContents().getDatasetDescriptionSummaryList().stream().filter(x -> x.getIdentifier().getStringValue().equals(id)).findFirst();
    }

    boolean tmsNotExistent(String tms) {
        Optional<TileMatrixSetDocument.TileMatrixSet> xx = this.findTileMatrixSetById(tms);
        if (xx.isEmpty()) {
            log.info("TileMatrixSet {} not existing in Capabilities. Setting default", (Object)tms);
        }
        return xx.isEmpty();
    }

    boolean layerNotExistent(String layer) {
        Optional<DatasetDescriptionSummaryBaseType> xx = this.findLayerById(layer);
        if (xx.isEmpty()) {
            log.info("Layer  {} not existing in Capabilities. Setting default", (Object)layer);
        }
        return xx.isEmpty();
    }

    boolean isEmpty(String s) {
        return s == null || s.isBlank();
    }

    protected String getCapabilitiesUrl() {
        return this.url + DEFAULT_GET_CAPABILITIES_PATH;
    }

    @Override
    public Dimension getSizeInTiles(int zoom) {
        int width = this.tms.getTileMatrixList().get(zoom).getMatrixWidth().intValue();
        int height = this.tms.getTileMatrixList().get(zoom).getMatrixHeight().intValue();
        return new Dimension(width, height);
    }

    @Override
    public String createTileUrl(int x, int y, int zoom) {
        return HttpUrl.parse(this.url).newBuilder().addQueryParameter("Service", "WMTS").addQueryParameter("Request", "GetTile").addQueryParameter("Layer", this.layerName).addQueryParameter("Version", "1.0.0").addQueryParameter("format", "image/png").addQueryParameter("style", "default").addQueryParameter("TileMatrixSet", this.tmsName).addQueryParameter("TileMatrix", this.tms.getTileMatrixList().get(zoom).getIdentifier().getStringValue()).addQueryParameter("TileRow", String.valueOf(y)).addQueryParameter("TileCol", String.valueOf(x)).toString();
    }

    @Override
    public Point2D getTopLeftCornerInMeters() {
        double x = (Double)this.tms.getTileMatrixList().get(0).getTopLeftCorner().get(0);
        double y = (Double)this.tms.getTileMatrixList().get(0).getTopLeftCorner().get(1);
        if (this.swapAxis) {
            return new Point2D.Double(y, x);
        }
        return new Point2D.Double(x, y);
    }

    @Override
    public double getMetersPerPixelAtZoom(int zoom) {
        return this.tms.getTileMatrixList().get(zoom).getScaleDenominator() * 2.8E-4;
    }
}

