/*
 * Decompiled with CFR 0.152.
 */
package net.wirelabs.jmaps.map.cache;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import javax.imageio.ImageIO;
import net.wirelabs.jmaps.map.Defaults;
import net.wirelabs.jmaps.map.cache.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryBasedCache
implements Cache<String, BufferedImage> {
    private static final Logger log = LoggerFactory.getLogger(DirectoryBasedCache.class);
    private final Path baseDir;
    private Duration cacheTimeout;

    public DirectoryBasedCache() {
        this(Defaults.DEFAULT_TILECACHE_DIR, Defaults.DEFAULT_CACHE_TIMEOUT);
    }

    public DirectoryBasedCache(String cacheDir, Duration cacheTimeout) {
        this.baseDir = Paths.get(cacheDir, new String[0]);
        this.cacheTimeout = cacheTimeout;
        if (cacheTimeout.isZero()) {
            log.info("Directory based cache expiration checking disabled!");
        } else {
            log.info("Directory based cache expiration timeout set to {}", (Object)cacheTimeout);
        }
    }

    @Override
    public BufferedImage get(String key) {
        try {
            File f = this.getLocalFile(key);
            if (this.validityTimeGreaterThanZero() && this.keyExpired(key)) {
                return null;
            }
            return ImageIO.read(Files.newInputStream(f.toPath(), new OpenOption[0]));
        }
        catch (IOException e) {
            return null;
        }
    }

    private boolean validityTimeGreaterThanZero() {
        return this.getCacheTimeout().toMillis() > Duration.ZERO.toMillis();
    }

    @Override
    public void put(String key, BufferedImage b) {
        try {
            File file = this.getLocalFile(key);
            if (!file.exists()) {
                Files.createDirectories(file.toPath(), new FileAttribute[0]);
            }
            this.writeImageToFile(b, file);
        }
        catch (IOException ex) {
            log.error("File cache put failed for {}", (Object)key, (Object)ex);
        }
    }

    void writeImageToFile(BufferedImage image, File file) throws IOException {
        ImageIO.write((RenderedImage)image, "png", file);
    }

    public boolean keyExpired(String key) {
        long lastWrittenOn;
        File file = this.getLocalFile(key);
        long expirationTime = System.currentTimeMillis() - this.getCacheTimeout().toMillis();
        try {
            lastWrittenOn = Files.getLastModifiedTime(file.toPath(), new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            return false;
        }
        return lastWrittenOn < expirationTime;
    }

    private File getLocalFile(String remoteUri) {
        URI uri = URI.create(remoteUri);
        StringBuilder sb = new StringBuilder();
        String host = uri.getHost();
        String query = uri.getQuery();
        String path = uri.getPath();
        if (host != null) {
            sb.append(host);
        }
        if (path != null) {
            sb.append(path);
        }
        if (query != null) {
            sb.append('?');
            sb.append(query);
        }
        int maxLen = 250;
        String name = sb.length() < 250 ? sb.toString() : sb.substring(0, 250);
        name = this.normalizeUrl(name);
        return new File(this.baseDir.toFile(), name);
    }

    private String normalizeUrl(String name) {
        char[] charsNormalized;
        char replacementChar = '$';
        for (char nchar : charsNormalized = new char[]{'&', '?', '*', ':', '<', '>', '\"'}) {
            name = name.replace(nchar, replacementChar);
        }
        return name;
    }

    public Path getBaseDir() {
        return this.baseDir;
    }

    public Duration getCacheTimeout() {
        return this.cacheTimeout;
    }

    public void setCacheTimeout(Duration cacheTimeout) {
        this.cacheTimeout = cacheTimeout;
    }
}

