/*
 * Decompiled with CFR 0.152.
 */
package net.wirelabs.jmaps.map;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;

public class TileDebugger {
    private static final Font FONT = new Font("Dialog", 1, 10);
    private static final String TILE_INFO_FORMAT = "[%d/%d/%d]";
    private static final int MARGIN = 4;

    public static void drawTileDebugInfo(Graphics graphics, int tileSize, int tileX, int tileY, int px, int py, int zoom) {
        graphics.setFont(FONT);
        String text = String.format(TILE_INFO_FORMAT, tileX, tileY, zoom);
        Rectangle2D textBounds = graphics.getFontMetrics().getStringBounds(text, graphics);
        graphics.setColor(Color.WHITE);
        graphics.fillRect(px, py, (int)(textBounds.getWidth() + 4.0), (int)(textBounds.getHeight() + 4.0));
        graphics.setColor(Color.BLACK);
        graphics.drawRect(px, py, (int)(textBounds.getWidth() + 4.0), (int)(textBounds.getHeight() + 4.0));
        graphics.drawString(text, px + 2, (int)((double)py + textBounds.getHeight()) + 2);
        graphics.drawRect(px, py, tileSize, tileSize);
    }

    private TileDebugger() {
    }
}

