/*
 * Decompiled with CFR 0.152.
 */
package net.wirelabs.jmaps.map;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import net.wirelabs.jmaps.map.MapViewer;
import net.wirelabs.jmaps.map.geo.Coordinate;
import net.wirelabs.jmaps.map.layer.Layer;

public class MouseHandler
extends MouseInputAdapter
implements MouseWheelListener {
    private final MapViewer mapViewer;
    private Cursor priorCursor;
    private final Point topLeftCorner;
    private final Point currentMousePosition = new Point();
    private final Point prevMousePosition = new Point();

    public MouseHandler(MapViewer mapViewer) {
        this.mapViewer = mapViewer;
        this.topLeftCorner = mapViewer.getTopLeftCornerPoint();
        mapViewer.addMouseMotionListener(this);
        mapViewer.addMouseListener(this);
        mapViewer.addMouseWheelListener(this);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent evt) {
        if (this.mapViewer.getCurrentMap().layersPresent()) {
            this.updateMousePoint(evt);
            Layer baseLayer = this.mapViewer.getCurrentMap().getBaseLayer();
            Coordinate mouseLatLon = baseLayer.pixelToLatLon(this.currentMousePosition, this.mapViewer.getZoom());
            int zoom = this.mapViewer.getZoom() - evt.getWheelRotation();
            int minZoomAllLayers = this.mapViewer.getCurrentMap().getMinZoom();
            int maxZoomAllLayers = this.mapViewer.getCurrentMap().getMaxZoom();
            if (zoom >= minZoomAllLayers && zoom <= maxZoomAllLayers) {
                Point2D p = baseLayer.latLonToPixel(mouseLatLon, zoom);
                this.updateTopLeftCornerPoint(evt, p);
                this.updateMousePoint(evt);
                this.mapViewer.setZoom(zoom);
                this.mapViewer.repaint();
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.updateMousePoint(mouseEvent);
        this.mapViewer.repaint();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        this.prevMousePosition.setLocation(mouseEvent.getPoint());
        this.priorCursor = this.mapViewer.getCursor();
        this.mapViewer.setCursor(Cursor.getPredefinedCursor(13));
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        Point currentMousePoint = mouseEvent.getPoint();
        int deltaX = this.prevMousePosition.x - currentMousePoint.x;
        int deltaY = this.prevMousePosition.y - currentMousePoint.y;
        this.topLeftCorner.translate(deltaX, deltaY);
        this.clipToBounds();
        this.prevMousePosition.setLocation(currentMousePoint);
        this.updateMousePoint(mouseEvent);
        this.mapViewer.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.prevMousePosition.setLocation(0, 0);
        this.mapViewer.setCursor(this.priorCursor);
    }

    private void clipToBounds() {
        if (this.mapViewer.getCurrentMap().layersPresent()) {
            int zoom = this.mapViewer.getZoom();
            int maxX = this.mapViewer.getMapSizeInPixels((int)zoom).width - this.mapViewer.getWidth();
            int maxY = this.mapViewer.getMapSizeInPixels((int)zoom).height - this.mapViewer.getHeight();
            if (this.topLeftCorner.x < 0) {
                this.topLeftCorner.x = 0;
            }
            if (this.topLeftCorner.y < 0) {
                this.topLeftCorner.y = 0;
            }
            if (this.topLeftCorner.x >= maxX) {
                this.topLeftCorner.x = maxX;
            }
            if (this.topLeftCorner.y >= maxY) {
                this.topLeftCorner.y = maxY;
            }
        }
    }

    private void updateMousePoint(MouseEvent mouseEvent) {
        this.currentMousePosition.setLocation(mouseEvent.getX() + this.topLeftCorner.x, mouseEvent.getY() + this.topLeftCorner.y);
    }

    private void updateTopLeftCornerPoint(MouseWheelEvent mouseEvent, Point2D point) {
        this.topLeftCorner.setLocation((int)point.getX() - mouseEvent.getX(), (int)point.getY() - mouseEvent.getY());
    }

    public Point getCurrentMousePosition() {
        return this.currentMousePosition;
    }
}

