/*
 * Decompiled with CFR 0.152.
 */
package net.wirelabs.jmaps.map;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import net.wirelabs.jmaps.map.MapCreator;
import net.wirelabs.jmaps.map.MapInfoPanel;
import net.wirelabs.jmaps.map.MapObject;
import net.wirelabs.jmaps.map.MapRenderer;
import net.wirelabs.jmaps.map.MouseHandler;
import net.wirelabs.jmaps.map.RecenterMapListener;
import net.wirelabs.jmaps.map.cache.Cache;
import net.wirelabs.jmaps.map.downloader.DownloadingTileProvider;
import net.wirelabs.jmaps.map.downloader.TileProvider;
import net.wirelabs.jmaps.map.exceptions.CriticalMapException;
import net.wirelabs.jmaps.map.geo.Coordinate;
import net.wirelabs.jmaps.map.geo.GeoUtils;
import net.wirelabs.jmaps.map.layer.Layer;
import net.wirelabs.jmaps.map.painters.Painter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapViewer
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(MapViewer.class);
    private final transient MapRenderer mapRenderer;
    private final transient MouseHandler mouseHandler;
    private final transient TileProvider downloadingTileProvider;
    private final transient MapCreator mapCreator;
    private final Point topLeftCornerPoint = new Point();
    private final MapInfoPanel mapInfoPanel;
    private final transient ConcurrentLinkedHashMap<String, BufferedImage> primaryTileCache;
    private transient Cache<String, BufferedImage> secondaryTileCache;
    private String userAgent = "JMaps Tiler v.1.0";
    private int tilerThreads = 16;
    private int zoom = 3;
    private transient Coordinate home;
    private boolean developerMode = false;
    private boolean showCoordinates = false;
    private boolean showAttribution = true;
    private final List<Painter<MapViewer>> userOverlays = new ArrayList<Painter<MapViewer>>();
    private transient MapObject currentMap = new MapObject();

    public MapViewer() {
        this.downloadingTileProvider = new DownloadingTileProvider(this);
        this.mapRenderer = new MapRenderer(this, this.downloadingTileProvider);
        this.mouseHandler = new MouseHandler(this);
        this.mapInfoPanel = new MapInfoPanel(this);
        this.mapCreator = new MapCreator();
        this.primaryTileCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(8000L).build();
        this.setLayout(new MigLayout("", "[90%][]", "[]"));
        this.add((Component)this.mapInfoPanel, "cell 1 1, grow");
        this.addComponentListener(new RecenterMapListener(this));
    }

    @Override
    protected void paintComponent(Graphics graphicsContext) {
        super.paintComponent(graphicsContext);
        this.mapRenderer.renderMap(graphicsContext);
        super.paintBorder(graphicsContext);
    }

    public void centerOnLocation(Coordinate location) {
        Layer baseLayer = this.currentMap.getBaseLayer();
        Rectangle2D.Double mapBounds = new Rectangle2D.Double(0.0, 0.0, this.getMapSizeInPixels((int)this.zoom).width, this.getMapSizeInPixels((int)this.zoom).height);
        if (location == null || !mapBounds.contains(baseLayer.latLonToPixel(location, this.zoom))) {
            double x = (double)this.getMapSizeInPixels((int)this.zoom).width / 2.0;
            double y = (double)this.getMapSizeInPixels((int)this.zoom).height / 2.0;
            this.topLeftCornerPoint.setLocation((int)(x - (double)this.getWidth() / 2.0), (int)(y - (double)this.getHeight() / 2.0));
        } else {
            Point2D p = baseLayer.latLonToPixel(location, this.zoom);
            this.topLeftCornerPoint.setLocation((int)(p.getX() - (double)this.getWidth() / 2.0), (int)(p.getY() - (double)this.getHeight() / 2.0));
        }
    }

    public Dimension getMapSizeInPixels(int zoom) {
        Layer baselayer = this.currentMap.getBaseLayer();
        return new Dimension(baselayer.getSizeInTiles((int)zoom).width * baselayer.getTileSize(), baselayer.getSizeInTiles((int)zoom).height * baselayer.getTileSize());
    }

    public void setCurrentMap(File xmlMapFile) {
        try {
            this.currentMap = this.mapCreator.createMap(xmlMapFile);
            this.updateLayersPanel();
            this.centerMapOrBestFit();
        }
        catch (CriticalMapException e) {
            JOptionPane.showMessageDialog(this.getParent(), e.getMessage());
        }
    }

    void centerMapOrBestFit() {
        List<Coordinate> allObjects = this.userOverlays.stream().flatMap(listContainer -> listContainer.getObjects().stream()).collect(Collectors.toList());
        if (!allObjects.isEmpty()) {
            this.setBestFit(allObjects);
        } else {
            this.setPositionAndZoom(this.getHome(), this.getZoom());
        }
    }

    public void addUserOverlay(Painter<MapViewer> painter) {
        this.userOverlays.add(painter);
    }

    public void setPositionAndZoom(Coordinate home, int zoom) {
        this.setZoom(zoom);
        this.centerOnLocation(home);
        this.repaint();
    }

    public void setBestFit(List<Coordinate> coordinates) {
        if (this.getCurrentMap().layersPresent()) {
            for (int fitZoom = this.currentMap.getBaseLayer().getMaxZoom(); fitZoom > 0; --fitZoom) {
                Rectangle2D routeRec = this.getEnclosingRectangle(coordinates, fitZoom);
                if (!(routeRec.getWidth() <= (double)this.getWidth()) || !(routeRec.getHeight() <= (double)this.getHeight())) continue;
                this.setPositionAndZoom(GeoUtils.calculateCenterOfCoordinateSet(coordinates), fitZoom);
                return;
            }
        }
    }

    private Rectangle2D getEnclosingRectangle(List<Coordinate> coords, int zoom) {
        Layer baseLayer = this.currentMap.getBaseLayer();
        List<Coordinate> pixelCoords = coords.stream().map(coord -> new Coordinate(baseLayer.latLonToPixel((Coordinate)coord, zoom).getX(), baseLayer.latLonToPixel((Coordinate)coord, zoom).getY())).collect(Collectors.toList());
        Rectangle2D r2 = GeoUtils.calculateEnclosingRectangle(pixelCoords);
        r2.setRect(r2.getX() - (double)this.topLeftCornerPoint.x, r2.getY() - (double)this.topLeftCornerPoint.y, r2.getWidth(), r2.getHeight());
        return r2;
    }

    public void setImageCacheSize(long size) {
        this.primaryTileCache.setCapacity(size);
    }

    public void setZoom(int zoom) {
        if (this.currentMap.layersPresent()) {
            int minZoomAllLayers = this.currentMap.getMinZoom();
            int maxZoomAllLayers = this.currentMap.getMaxZoom();
            if (zoom < minZoomAllLayers) {
                zoom = minZoomAllLayers;
            }
            if (zoom > maxZoomAllLayers) {
                zoom = maxZoomAllLayers;
            }
        }
        this.zoom = zoom;
    }

    public void updateLayersPanel() {
        if (this.currentMap.isMultilayer()) {
            this.mapInfoPanel.addLayers();
        }
        this.mapInfoPanel.setVisible(this.currentMap.isMultilayer());
    }

    public MouseHandler getMouseHandler() {
        return this.mouseHandler;
    }

    public Point getTopLeftCornerPoint() {
        return this.topLeftCornerPoint;
    }

    public ConcurrentLinkedHashMap<String, BufferedImage> getPrimaryTileCache() {
        return this.primaryTileCache;
    }

    public Cache<String, BufferedImage> getSecondaryTileCache() {
        return this.secondaryTileCache;
    }

    public void setSecondaryTileCache(Cache<String, BufferedImage> secondaryTileCache) {
        this.secondaryTileCache = secondaryTileCache;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public int getTilerThreads() {
        return this.tilerThreads;
    }

    public void setTilerThreads(int tilerThreads) {
        this.tilerThreads = tilerThreads;
    }

    public int getZoom() {
        return this.zoom;
    }

    public Coordinate getHome() {
        return this.home;
    }

    public void setHome(Coordinate home) {
        this.home = home;
    }

    public boolean isDeveloperMode() {
        return this.developerMode;
    }

    public void setDeveloperMode(boolean developerMode) {
        this.developerMode = developerMode;
    }

    public boolean isShowCoordinates() {
        return this.showCoordinates;
    }

    public void setShowCoordinates(boolean showCoordinates) {
        this.showCoordinates = showCoordinates;
    }

    public boolean isShowAttribution() {
        return this.showAttribution;
    }

    public void setShowAttribution(boolean showAttribution) {
        this.showAttribution = showAttribution;
    }

    public List<Painter<MapViewer>> getUserOverlays() {
        return this.userOverlays;
    }

    public MapObject getCurrentMap() {
        return this.currentMap;
    }
}

