/*
 * Decompiled with CFR 0.152.
 */
package net.wirelabs.jmaps.example.components;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import net.wirelabs.jmaps.example.gpx.GpxType;
import net.wirelabs.jmaps.example.gpx.TrkType;
import net.wirelabs.jmaps.example.gpx.TrksegType;
import net.wirelabs.jmaps.example.gpx.WptType;
import net.wirelabs.jmaps.map.geo.Coordinate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPXParser {
    private static final Logger log = LoggerFactory.getLogger(GPXParser.class);
    private Unmarshaller unmarshaller;

    public GPXParser() {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"net.wirelabs.jmaps.example.gpx");
            this.unmarshaller = jc.createUnmarshaller();
        }
        catch (JAXBException e) {
            log.error("JAXB exception {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public List<Coordinate> parseToGeoPosition(File file) {
        return this.parseGpxFile(file).stream().map(this::trackPointToCoordinate).collect(Collectors.toList());
    }

    private Coordinate trackPointToCoordinate(WptType trackPoint) {
        Coordinate coordinate = trackPoint.getEle() == null ? new Coordinate(trackPoint.getLon().doubleValue(), trackPoint.getLat().doubleValue()) : new Coordinate(trackPoint.getLon().doubleValue(), trackPoint.getLat().doubleValue(), trackPoint.getEle().doubleValue());
        return coordinate;
    }

    public List<WptType> parseGpxFile(File file) {
        try {
            JAXBElement root = (JAXBElement)this.unmarshaller.unmarshal(file);
            List<TrkType> tracks = ((GpxType)root.getValue()).getTrk();
            ArrayList<WptType> result = new ArrayList<WptType>();
            if (!tracks.isEmpty()) {
                for (TrkType track : tracks) {
                    track.getTrkseg().stream().map(TrksegType::getTrkpt).forEach(result::addAll);
                }
                return result;
            }
        }
        catch (JAXBException e) {
            log.warn("File does not contain a gpx track");
        }
        return Collections.emptyList();
    }
}

