/*
 * Decompiled with CFR 0.152.
 */
package net.wirelabs.jmaps.example.components;

import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.net.URL;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import net.miginfocom.swing.MigLayout;
import net.wirelabs.jmaps.example.components.ExampleMap;
import net.wirelabs.jmaps.example.components.GPXParser;
import net.wirelabs.jmaps.example.components.MapPanel;
import net.wirelabs.jmaps.example.components.RoutePainter;
import net.wirelabs.jmaps.example.components.TitledPanel;
import net.wirelabs.jmaps.map.MapViewer;
import net.wirelabs.jmaps.map.geo.Coordinate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigPanel
extends TitledPanel {
    private static final Logger log = LoggerFactory.getLogger(ConfigPanel.class);
    public static final File HOME_DIR = new File(System.getProperty("user.home"));
    private final JButton btnAddLayer = new JButton("Load custom map");
    private final JButton btnLoadGPX = new JButton("Load gpx track");
    private final JCheckBox devMode = new JCheckBox("Tile debugger");
    private final JLabel label = new JLabel("Example map definitions");
    private final JComboBox<ExampleMap> exampleMapCombo = new JComboBox<ExampleMap>(ExampleMap.values());
    private final MapViewer mapViewer;
    private final transient RoutePainter routePainter;
    private JFileChooser fileChooser;

    public ConfigPanel(MapPanel mapPanel) {
        super("Config");
        this.mapViewer = mapPanel.getMapViewer();
        this.routePainter = mapPanel.getRoutePainter();
        this.add((Component)this.label, "cell 0 1, growx");
        this.add(this.exampleMapCombo, "cell 0 2, growx");
        this.add((Component)this.btnAddLayer, "cell 0 3, growx");
        this.add((Component)this.btnLoadGPX, "cell 0 4, growx");
        this.add((Component)this.devMode, "flowx,cell 0 5");
        this.devMode.setSelected(this.mapViewer.isDeveloperMode());
        this.setTooltips();
        this.setComboBoxRenderer();
        this.addListeners();
    }

    private void setTooltips() {
        this.devMode.setToolTipText("Enables visual tile debug");
        this.btnAddLayer.setToolTipText("Load custom map (from XML file)");
        this.btnLoadGPX.setToolTipText("Load and visualise a gpx track");
    }

    private void addListeners() {
        this.setAddMapListener();
        this.setLoadGPXListener();
        this.setDevModeListener();
        this.setComboChangeListener();
    }

    private void setComboBoxRenderer() {
        this.exampleMapCombo.setRenderer(new BasicComboBoxRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                ExampleMap item = (ExampleMap)((Object)value);
                this.setText(item.getName());
                return this;
            }
        });
    }

    private void setComboChangeListener() {
        this.exampleMapCombo.addActionListener(e -> {
            URL path;
            ExampleMap selected = (ExampleMap)((Object)((Object)this.exampleMapCombo.getSelectedItem()));
            if (selected != null && (path = this.getClass().getClassLoader().getResource(selected.getMapFile())) != null) {
                File file = new File(path.getFile());
                this.mapViewer.setCurrentMap(file);
            }
        });
    }

    private void setDevModeListener() {
        this.devMode.addActionListener(e -> {
            this.mapViewer.setDeveloperMode(this.devMode.isSelected());
            this.mapViewer.repaint();
        });
    }

    private void setLoadGPXListener() {
        this.btnLoadGPX.addActionListener(e -> this.invokeFileChooser("GPX tracks", "gpx", () -> {
            File gpx = this.fileChooser.getSelectedFile();
            GPXParser p = new GPXParser();
            List<Coordinate> gpxCoordinates = p.parseToGeoPosition(gpx);
            this.routePainter.setRoute(gpxCoordinates);
            this.mapViewer.setBestFit(gpxCoordinates);
        }));
    }

    private void setAddMapListener() {
        this.btnAddLayer.addActionListener(e -> this.invokeFileChooser("Map definition files", "xml", () -> {
            File mapxml = this.fileChooser.getSelectedFile();
            this.mapViewer.setCurrentMap(mapxml);
        }));
    }

    private void invokeFileChooser(String type, String fileExtensions, Runnable actionOnApprove) {
        this.fileChooser = new JFileChooser();
        this.fileChooser.setCurrentDirectory(HOME_DIR);
        this.fileChooser.setFileFilter(new FileNameExtensionFilter(type, fileExtensions));
        int result = this.fileChooser.showOpenDialog((Component)this.mapViewer);
        if (result == 0) {
            actionOnApprove.run();
        }
    }

    public void setFirstAvailableMap() {
        this.exampleMapCombo.setSelectedIndex(0);
    }

    @Override
    protected LayoutManager customLayout() {
        return new MigLayout("", "[grow]", "[][][][][][][][][][][][]");
    }
}

