/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.telnetd.io.toolkit;

import java.io.IOException;
import net.wimpi.telnetd.io.BasicTerminalIO;
import net.wimpi.telnetd.io.toolkit.ActiveComponent;

public class Checkbox
extends ActiveComponent {
    private String m_Text = "";
    private boolean m_Selected = false;
    private String m_Mark;
    private String m_LeftBracket;
    private String m_RightBracket;
    public static final int SMALL_CHECKMARK = 10;
    public static final int LARGE_CHECKMARK = 11;
    public static final int SQUARED_BOXSTYLE = 1;
    public static final int ROUND_BOXSTYLE = 2;
    public static final int EDGED_BOXSTYLE = 3;
    private static final int SPACE = 32;

    public Checkbox(BasicTerminalIO io, String name) {
        super(io, name);
        this.setBoxStyle(1);
        this.setMarkStyle(11);
    }

    public void setSelected(boolean b) throws IOException {
        this.m_Selected = b;
        this.drawMark();
    }

    public boolean isSelected() {
        return this.m_Selected;
    }

    public void setText(String str) {
        this.m_Text = str;
    }

    public void setBoxStyle(int style) {
        switch (style) {
            case 2: {
                this.m_LeftBracket = "(";
                this.m_RightBracket = ")";
                break;
            }
            case 3: {
                this.m_LeftBracket = "<";
                this.m_RightBracket = ">";
                break;
            }
            default: {
                this.m_LeftBracket = "[";
                this.m_RightBracket = "]";
            }
        }
    }

    public void setMarkStyle(int style) {
        switch (style) {
            case 10: {
                this.m_Mark = "x";
                break;
            }
            default: {
                this.m_Mark = "X";
            }
        }
    }

    public void run() throws IOException {
        int in = 0;
        this.draw();
        this.m_IO.flush();
        do {
            in = this.m_IO.read();
            switch (in) {
                case 32: {
                    this.setSelected(!this.m_Selected);
                    break;
                }
                case 10: 
                case 1301: {
                    in = -1;
                    break;
                }
                default: {
                    this.m_IO.bell();
                }
            }
            this.m_IO.flush();
        } while (in != -1);
    }

    public void draw() throws IOException {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(" ");
        sbuf.append(this.m_LeftBracket);
        if (this.m_Selected) {
            sbuf.append(this.m_Mark);
        } else {
            sbuf.append(" ");
        }
        sbuf.append(this.m_RightBracket);
        sbuf.append(" ");
        sbuf.append(this.m_Text);
        if (this.m_Position != null) {
            this.m_IO.setCursor(this.m_Position.getRow(), this.m_Position.getColumn());
        }
        this.m_IO.write(sbuf.toString());
        this.m_IO.moveLeft(3 + this.m_Text.length());
        this.m_IO.flush();
    }

    private void drawMark() throws IOException {
        if (this.m_Position != null) {
            this.m_IO.storeCursor();
            this.m_IO.setCursor(this.m_Position.getRow(), this.m_Position.getColumn());
            this.m_IO.moveRight(2);
        }
        if (this.m_Selected) {
            this.m_IO.write(this.m_Mark);
        } else {
            this.m_IO.write(" ");
        }
        if (this.m_Position == null) {
            this.m_IO.moveLeft(1);
        } else {
            this.m_IO.restoreCursor();
        }
        this.m_IO.flush();
    }
}

