/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.plugin.task.project;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javassist.CtClass;
import net.wicp.tams.commons.apiext.StringUtil;
import net.wicp.tams.commons.apiext.XmlUtil;
import net.wicp.tams.commons.tracer.instrumentation.AbsHandler;
import net.wicp.tams.commons.tracer.instrumentation.IClassEnhance;
import net.wicp.tams.plugin.TaskAssit;
import net.wicp.tams.plugin.constant.SupClass;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.ExpressionEngine;
import org.apache.commons.configuration.tree.xpath.XPathExpressionEngine;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="trace", threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class Trace
extends AbstractMojo {
    private static final String _trace = "trace";
    private static final String _super = "super";
    private static final String _include = "include";
    private static final String _exclude = "exclude";
    private static final String _enclassname = "enclassname";
    private List<String> hasClassName = new ArrayList<String>();
    @Parameter(defaultValue="${project.build.outputDirectory}/trace.xml", property="config", required=true)
    private File config;
    @Parameter(defaultValue="${project.build.outputDirectory}", property="classroot", required=true)
    private File classroot;
    @Parameter(defaultValue="${project.basedir}/", required=true)
    private String basedir;
    @Parameter(defaultValue="${project}", required=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            TaskAssit.addProjectClassPath(this.project, AbsHandler.pool);
        }
        catch (Exception e) {
            throw new MojoFailureException("-----------------\u52a0classpath\u9519\u8bef---------", (Throwable)e);
        }
        File homeDir = new File(String.format("%s/%s/%s/%s", System.getProperty("user.home"), "/.tams/", _trace, this.project.getArtifactId()));
        try {
            if (homeDir.exists()) {
                FileUtils.forceDelete((File)homeDir);
            }
            homeDir.mkdirs();
            XMLConfiguration xml = null;
            try {
                xml = new XMLConfiguration(this.config);
                xml.setEncoding("UTF-8");
                xml.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
            }
            catch (Exception e) {
                throw new MojoFailureException("\u8bfb\u7f13\u5b58\u914d\u7f6e\u9519\u8bef,\u9ed8\u8ba4\u6587\u4ef6\u4e3atrace.xml.");
            }
            HierarchicalConfiguration.Node node = xml.getRoot();
            if (StringUtils.isBlank((String)node.getName()) || "null".equals(node.getName())) {
                this.getLog().info((CharSequence)"------------------------trace---end------\u6ca1\u6709\u627e\u5230\u5408\u9002\u7684\u914d\u7f6e\u6587\u4ef6-----------");
                return;
            }
            if (!_trace.equalsIgnoreCase(node.getName())) {
                throw new MojoFailureException(String.format("\u914d\u7f6e\u6587\u4ef6\u9519\u8bef:\u6839\u5fc5\u987b\u4e3a%s", _trace));
            }
            this.getLog().info((CharSequence)"------------------------\u52a0\u5f3atrace\u7684\u5b57\u8282\u7801---begin---------------------");
            List cachelist = node.getChildren(_super);
            if (CollectionUtils.isEmpty((Collection)cachelist)) {
                return;
            }
            for (int i = 0; i < cachelist.size(); ++i) {
                ConfigurationNode superNode = (ConfigurationNode)cachelist.get(i);
                final List includeList = XmlUtil.getChildValues((ConfigurationNode)superNode, (String)_include);
                final List excludeList = XmlUtil.getChildValues((ConfigurationNode)superNode, (String)_exclude);
                String enclassname = XmlUtil.findValueByAttrName((ConfigurationNode)superNode, (String)_enclassname);
                SupClass supClass = null;
                if (StringUtil.isNotNull((Object)enclassname) && (supClass = SupClass.getByName(enclassname)) == null) {
                    throw new MojoFailureException("-----------------\u4e0d\u652f\u6301\u7684\u7236\u7c7b[" + enclassname + "]---------");
                }
                Set<String> sublist = TaskAssit.findSubClassByProject(this.getLog(), supClass.getClassName(), this.project, AbsHandler.pool);
                if (CollectionUtils.isNotEmpty((Collection)includeList)) {
                    CollectionUtils.filter(sublist, (Predicate)new Predicate(){

                        public boolean evaluate(Object object) {
                            String className = String.valueOf(object);
                            return includeList.contains(className);
                        }
                    });
                }
                if (CollectionUtils.isNotEmpty((Collection)excludeList)) {
                    CollectionUtils.filter(sublist, (Predicate)new Predicate(){

                        public boolean evaluate(Object object) {
                            String className = String.valueOf(object);
                            return !excludeList.contains(className);
                        }
                    });
                }
                if (CollectionUtils.isEmpty(sublist)) continue;
                for (String subClassName : sublist) {
                    IClassEnhance enhance = (IClassEnhance)Class.forName(supClass.getEnhanceClassName()).getConstructor(String.class).newInstance(subClassName);
                    if (StringUtils.isEmpty((String)subClassName) || this.hasClassName.contains(subClassName)) continue;
                    CtClass cc = enhance.transformed();
                    if (cc != null) {
                        cc.writeFile(homeDir.getPath());
                    }
                    this.hasClassName.add(subClassName);
                }
            }
        }
        catch (Exception e) {
            throw new MojoFailureException("-----------------\u52a0\u5f3atrace\u7684\u5b57\u8282\u7801\u9519\u8bef---------", (Throwable)e);
        }
        try {
            FileUtils.copyDirectory((File)homeDir, (File)this.classroot, (boolean)true);
            this.getLog().info((CharSequence)"------------------------\u52a0\u5f3atrace\u7684\u5b57\u8282\u7801---end---------------------");
        }
        catch (IOException e) {
            throw new MojoFailureException("-----------------\u52a0\u5f3a\u590d\u5236\u6587\u4ef6\u51fa\u9519---------", (Throwable)e);
        }
    }
}

