package net.wicp.tams.plugin.task.project;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

import net.wicp.tams.commons.constant.BasePath;
import net.wicp.tams.plugin.TaskAssit;

/***
 * 把缓存放到二进制编码中
 * 
 * @author andy.zhou
 *
 */
@Mojo(name = "log")
public class AddLogger extends AbstractMojo {

	// src的源路径
	@Parameter(defaultValue = "${project.artifactId}", required = true)
	private String projectname;

	@Override
	public void execute() throws MojoExecutionException, MojoFailureException {
		TaskAssit.proProjectFile(getLog(), "/temp/logback.xml", BasePath.source, "/logback.xml", "\\[projectName\\]",
				projectname);
	}

}
