package net.wicp.tams.plugin.task;

import java.util.Properties;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.zookeeper.data.Stat;

import net.wicp.tams.commons.Conf;
import net.wicp.tams.commons.Conf.InitCallback;
import net.wicp.tams.commons.apiext.StringUtil;
import net.wicp.tams.commons.constant.Env;
import net.wicp.tams.commons.constant.OptType;
import net.wicp.tams.commons.zookeeper.ZK;

/****
 * 修改zk上的数据,设置环境变量 [env]_zk 可以不传参数
 * 
 * @author zhoujunhui
 *
 */
@Mojo(name = "zk", requiresProject = false, threadSafe = true)
public class ZkOpt extends AbstractMojo {

	@Parameter(required = true, property = "path")
	private String path;

	@Parameter(required = false, property = "data")
	private String data;

	@Parameter(defaultValue = "dev", required = true, property = "env")
	private String env;
	// 操作类型
	@Parameter(defaultValue = "query", required = true, property = "opt")
	private String opt;
	// 连接字符串，集群用逗号隔开
	@Parameter(defaultValue = "127.0.0.1:2181", required = true, property = "conn")
	private String conn;

	@Override
	public void execute() throws MojoExecutionException, MojoFailureException {
		if ((StringUtil.isNull(env) || env.equals("dev")) && StringUtil.isNotNull(System.getenv("za.env"))) {
			env = System.getenv("za.env");
			getLog().info(String.format("-------使用环境变量的env：[%s]-------", env));
		}
		final Env curEnv = Env.getByName(env, null);
		if (curEnv == null) {
			throw new MojoFailureException("环境只能设置[dev|test|pre|prd]");
		}
		Conf.InitCallback callback = new InitCallback() {

			@Override
			public Properties doInitConf() {
				Properties pros = new Properties();
				pros.put("zookeeper.server.timeout", "60000");
				String envStr = System.getenv().get(String.format("%s_zk", curEnv.name()));
				if (StringUtil.isNull(conn) || ("127.0.0.1:2181".equals(conn) && StringUtil.isNotNull(envStr))) {
					conn = envStr;
					getLog().info(String.format("-------使用环境变量的connstr：[%s]-------", envStr));
				}
				pros.put("zookeeper.server.constr", conn);
				return pros;
			}
		};
		Conf.addCallBackInit("zk-plugin", callback);

		OptType opttype = OptType.getByName(opt);
		if (opttype == null) {
			throw new MojoFailureException("操作类型只能设置[insert|delete|update|query]");
		}
		ZK zk = ZK.getInstance();
		try {

			getLog().info("---------------------操作开始--------------------------------------");
			switch (opttype) {
			case query:
				String retstr = zk.getData(path);
				getLog().info(String.format("结点值为：[%s]", retstr));
				break;

			case delete:
				zk.deleteNode(path);
				getLog().info("删除节点成功");
				break;

			case insert:
				String newpath = null;
				if (StringUtil.isNull(data)) {
					newpath = zk.createNode(path);
				} else {
					newpath = zk.createNode(path, data);
				}
				if (newpath == null) {
					getLog().info("创建节点失败");
				} else {
					getLog().info("创建节点成功");
				}
				break;

			case update:
				Stat stat = null;
				if (StringUtil.isNull(data)) {
					stat = zk.updateNode(path, "");
				} else {
					stat = zk.updateNode(path, data);
				}
				if (stat == null) {
					getLog().info("更新节点失败");
				} else {
					getLog().info("更新节点成功");
				}
				break;
			default:
				getLog().info("不支持的操作");
				break;
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			ZK.destroy();
			getLog().info("zk 连接已关闭");
		}
		getLog().info("---------------------操作结束--------------------------------------");

	}

}
