package net.wicp.tams.plugin.task;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

import net.wicp.tams.commons.apiext.PwdUtil;

/***
 * 密码加密
 * 
 * @author zhoujunhui
 *
 */
@Mojo(name = "pwd", requiresProject = false)
public class Pwd extends AbstractMojo {

	/***
	 * 原始密码
	 */
	@Parameter(property = "ori", required = true)
	private String ori;

	/***
	 * 加密的key
	 */
	@Parameter(property = "key", defaultValue = "foxes@#**udk", required = false)
	private String key;

	@Override
	public void execute() throws MojoExecutionException, MojoFailureException {
		String retstr = PwdUtil.Encrypt3DES(ori, key);
		getLog().info(String.format("加密后代码：[%s]", retstr));
	}

}
