package net.wicp.tams.plugin.task;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

import net.wicp.tams.commons.constant.BasePath;
import net.wicp.tams.plugin.TaskAssit;

/****
 * 修改zk上的数据,设置环境变量 [env]_zk 可以不传参数
 * 
 * @author zhoujunhui
 *
 */
@Mojo(name = "bl", requiresProject = true, threadSafe = true)
public class BinLogConf extends AbstractMojo {

	@Parameter(defaultValue = "${project.artifactId}", required = true)
	private String projectname;

	@Parameter(defaultValue = "${project.version}", required = true)
	private String version;

	@Parameter(defaultValue = "${basedir}", required = true)
	private String basedir;
	/***
	 * 程序所在的根目录
	 */
	@Parameter(defaultValue = "/alidata1/admin/zorro", required = true, property = "dir")
	private String dir;

	@Override
	public void execute() throws MojoExecutionException, MojoFailureException {
		BasePath.projectBasePath = basedir;
		String jarNameFull = String.format("%s-%s.jar", projectname, version);
		TaskAssit.proProjectFile(getLog(), "/template/binlog/task.bat", BasePath.target, "/bin/task.bat",
				"\\[jarNameFull\\]", jarNameFull, "\\[dir\\]", dir);
		TaskAssit.proProjectFile(getLog(), "/template/binlog/task.sh", BasePath.target, "/bin/task.sh",
				"\\[jarNameFull\\]", jarNameFull, "\\[dir\\]", dir);
	}

}
