package net.wicp.tams.plugin.constant;

public enum SupClass {
	HttpServlet("http服务加强", "javax.servlet.http.HttpServlet",
			"net.wicp.tams.commons.tracer.instrumentation.impl.EnhanceHttpServlet"),

	HttpClient("apache http加强", "org.apache.http.client.HttpClient",
			"net.wicp.tams.commons.tracer.instrumentation.impl.EnhanceApacheHttpClient"),

	SqlDriver("数据库驱动加强", "java.sql.Driver", "net.wicp.tams.commons.tracer.instrumentation.impl.EnhanceJdbcDriver");

	private final String desc;
	private final String className;
	private final String enhanceClassName;

	private SupClass(String desc, String className, String enhanceClassName) {
		this.desc = desc;
		this.className = className;
		this.enhanceClassName = enhanceClassName;
	}

	private SupClass(String desc, String enhanceClassName) {
		this.desc = desc;
		this.className = null;
		this.enhanceClassName = enhanceClassName;
	}

	public static SupClass getByName(String name) {
		for (SupClass supclass : values()) {
			if (supclass.name().equals(name)) {
				return supclass;
			}
		}
		return null;
	}

	public String getDesc() {
		return desc;
	}

	public String getClassName() {
		return className;
	}

	public String getEnhanceClassName() {
		return enhanceClassName;
	}

}
