package net.wicp.tams.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

import org.apache.commons.collections.CollectionUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

import javassist.ClassPool;
import javassist.NotFoundException;
import net.wicp.tams.commons.Result;
import net.wicp.tams.commons.apiext.CollectionUtil;
import net.wicp.tams.commons.apiext.IOUtil;
import net.wicp.tams.commons.constant.BasePath;
import net.wicp.tams.commons.thread.ThreadPool;

public abstract class TaskAssit {
	public static void proProjectFile(Log log, String oriClassPath, BasePath destBase, String destPath,
			String... replace) {
		try {
			String oriStr = IOUtil.slurp(IOUtil.fileToInputStream(oriClassPath, TaskAssit.class));
			IOUtil.replaceFileByStr(oriStr, destBase, destPath, replace);
			log.info("-------------------生成[" + destPath + "]文件成功-------------------------");
		} catch (Exception e) {
			log.error("-------------------生成[" + destPath + "]文件失败-------------------------", e);
		}
	}

	/***
	 * 把项目的类加到classpool
	 * 
	 * @param project
	 * @param pool
	 * @throws NotFoundException
	 */
	public static void addProjectClassPath(MavenProject project, ClassPool pool) throws NotFoundException {
		if (project == null || pool == null) {
			return;
		}
		String outputPath = project.getBuild().getOutputDirectory();
		pool.appendClassPath(outputPath);
		Set<Artifact> allJars = project.getArtifacts();
		for (Artifact artifact : allJars) {
			File file = artifact.getFile();
			pool.appendClassPath(file.getPath());
		}
	}

	public static Set<String> findSubClassByProject(Log log, final String parentClassName, MavenProject project,
			final ClassPool pool) throws Exception {
		final Set<String> sublist = new HashSet<>();
		if (project == null || pool == null) {
			return sublist;
		}
		String outputPath = project.getBuild().getOutputDirectory();
		List<String> dirlist = IOUtil.getSubTypeFromDir(outputPath, null, parentClassName, pool);
		sublist.addAll(dirlist);

		Set<Artifact> allJars = project.getArtifacts();
		List<Artifact> listall = new ArrayList<>();
		listall.addAll(allJars);
		int threadnum = 60;
		List<List<Artifact>> inputlist = CollectionUtil.splitListN(listall, threadnum);
		List<Future<Result>> furlist = new ArrayList<>();

		for (final List<Artifact> list : inputlist) {
			FutureTask<Result> aa = new FutureTask<Result>(new Callable<Result>() {

				@Override
				public Result call() throws Exception {
					for (Artifact artifact : list) {
						try {
							File file = artifact.getFile();
							List<String> templist = IOUtil.getSubType(file.getPath(), null, parentClassName, pool);
							sublist.addAll(templist);
						} catch (Exception e) {
							return Result.getError(String.format("[%s]执行失败", Thread.currentThread().getName()));
						}
					}
					return Result.getSuc(String.format("[%s]执行成功", Thread.currentThread().getName()));
				}
			});
			furlist.add(aa);
			ThreadPool.getDefaultPool().submit(aa);
		}
		for (Future<Result> future : furlist) {
			if (future.get().isSuc()) {
				log.info(future.get().getMessage());
			} else {
				log.info(future.get().getMessage());
			}
		}
		return sublist;
	}

}
