/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.plugin.task.svn;

import java.io.File;
import java.util.Date;
import net.wicp.tams.commons.apiext.SVNUtil;
import net.wicp.tams.commons.apiext.StringUtil;
import net.wicp.tams.commons.constant.DateFormatCase;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;

@Mojo(name="addsvn")
public class AddSVN
extends AbstractMojo {
    @Parameter(defaultValue="${project.basedir}/", required=false)
    private String basedir;
    @Parameter(defaultValue="maven_build,maven_build", required=false, property="user")
    private String user;
    @Parameter(property="svn", required=true)
    private String svn;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (StringUtil.isNull((Object)this.user)) {
            throw new MojoFailureException("\u5fc5\u987b\u4f20\u5165\u7528\u6237\uff1a\u7528\u6237\u540d\u3001\u5bc6\u7801\u4e2d\u95f4\u7528\u9017\u53f7\uff08,\uff09\u9694\u5f00");
        }
        Object[] userary = this.user.split(",");
        if (ArrayUtils.isEmpty((Object[])userary) || userary.length < 2) {
            throw new MojoFailureException("\u7528\u6237\u683c\u5f0f\u4e0d\u5bf9\uff0c\u6b63\u786e\u7684\u683c\u5f0f\u4e3a\uff1a\u7528\u6237\u540d,\u5bc6\u7801");
        }
        SVNUtil svnobj = SVNUtil.getInstance();
        SVNClientManager clientManager = svnobj.authSvn(this.svn, (String)userary[0], (String)userary[1]);
        File workDir = new File(this.basedir);
        if (!svnobj.isWorkingCopy(workDir)) {
            svnobj.checkout(clientManager, this.svn, SVNRevision.HEAD, workDir, SVNDepth.fromRecurse((boolean)false));
            svnobj.checkVersiondDirectory(clientManager, workDir);
            svnobj.commit(clientManager, workDir, true, "\u63d0\u4ea4SVN,\u65f6\u95f4:" + DateFormatCase.yyyyMMddHHmmss.getInstanc().format(new Date()));
            this.getLog().info((CharSequence)"-----\u63d0\u4ea4\u6210\u529f-----");
        } else {
            svnobj.overWrite(clientManager, workDir, this.svn);
        }
    }
}

