/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.plugin.task.cache;

import java.io.File;
import java.util.Collection;
import java.util.List;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.LocalVariableAttribute;
import net.wicp.tams.commons.apiext.XmlUtil;
import net.wicp.tams.plugin.constant.CacheColProperty;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.ExpressionEngine;
import org.apache.commons.configuration.tree.xpath.XPathExpressionEngine;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="addcache", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresProject=true, threadSafe=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class Addcache
extends AbstractMojo {
    public static final String CACHES = "caches";
    public static final String CACHE = "cache";
    public static final String METHOD = "method";
    public static final String GET = "get";
    public static final String PUT = "put";
    @Parameter(defaultValue="${project.build.outputDirectory}/cache.xml", required=true)
    private File config;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private String classroot;
    private String[] excludeType = new String[]{"String", "Integer"};

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"------------------------\u52a0\u5f3a\u7f13\u5b58---begin---------------------");
        XMLConfiguration xml = null;
        try {
            xml = new XMLConfiguration(this.config);
            xml.setEncoding("UTF-8");
            xml.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        }
        catch (Exception e) {
            throw new MojoFailureException("\u8bfb\u7f13\u5b58\u914d\u7f6e\u9519\u8bef,\u9ed8\u8ba4\u6587\u4ef6\u4e3acache.xml.");
        }
        HierarchicalConfiguration.Node node = xml.getRoot();
        if (StringUtils.isBlank((String)node.getName()) || "null".equals(node.getName())) {
            this.getLog().info((CharSequence)"------------------------\u52a0\u5f3a\u7f13\u5b58---end------\u6ca1\u6709\u627e\u5230\u5408\u9002\u7684\u914d\u7f6e\u6587\u4ef6-----------");
            return;
        }
        if (!CACHES.equalsIgnoreCase(node.getName())) {
            throw new MojoFailureException(String.format("\u914d\u7f6e\u6587\u4ef6\u9519\u8bef:\u6839\u5fc5\u987b\u4e3a%s", CACHES));
        }
        List cachelist = node.getChildren(CACHE);
        if (CollectionUtils.isEmpty((Collection)cachelist)) {
            return;
        }
        for (int i = 0; i < cachelist.size(); ++i) {
            List methodlist;
            ConfigurationNode cacheNode = (ConfigurationNode)cachelist.get(i);
            boolean checkresult = this.checkCacheMethed(cacheNode, i);
            if (!checkresult || CollectionUtils.isEmpty((Collection)(methodlist = cacheNode.getChildren(METHOD)))) continue;
            for (int j = 0; j < methodlist.size(); ++j) {
                ConfigurationNode methodNode = (ConfigurationNode)methodlist.get(j);
                String className = Addcache.findValueByAttrName(methodNode, CacheColProperty.classname);
                String name = Addcache.findValueByAttrName(methodNode, CacheColProperty.name);
                String key = Addcache.findValueByAttrName(methodNode, CacheColProperty.key);
                if (StringUtils.isBlank((String)className) || StringUtils.isBlank((String)name) || StringUtils.isBlank((String)key)) {
                    this.getLog().error((CharSequence)String.format("\u7b2c%s\u4e2aCache\u533a\u7b2c%s\u4e2a\u65b9\u6cd5\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570", i, j));
                    continue;
                }
                this.alterMethod(cacheNode, methodNode);
            }
        }
        this.getLog().info((CharSequence)"------------------------\u52a0\u5f3a\u7f13\u5b58---end---------------------");
    }

    private void alterMethod(ConfigurationNode cacheNode, ConfigurationNode methodNode) {
        ConfigurationNode getNode = XmlUtil.getFirstNodeByNodeName((ConfigurationNode)cacheNode, (String)GET);
        ConfigurationNode putNode = XmlUtil.getFirstNodeByNodeName((ConfigurationNode)cacheNode, (String)PUT);
        String staticnameGet = Addcache.findValueByAttrName(getNode, CacheColProperty.staticname);
        String classnameGet = Addcache.findValueByAttrName(getNode, CacheColProperty.classname);
        String staticnamePut = Addcache.findValueByAttrName(putNode, CacheColProperty.staticname);
        String classnamePut = Addcache.findValueByAttrName(putNode, CacheColProperty.classname);
        String className = Addcache.findValueByAttrName(methodNode, CacheColProperty.classname);
        String name = Addcache.findValueByAttrName(methodNode, CacheColProperty.name);
        String key = Addcache.findValueByAttrName(methodNode, CacheColProperty.key);
        String expire = Addcache.findValueByAttrName(methodNode, CacheColProperty.expire);
        String idcol = Addcache.findValueByAttrName(methodNode, CacheColProperty.idcol);
        String param = Addcache.findValueByAttrName(methodNode, CacheColProperty.param);
        idcol = StringUtils.isEmpty((String)idcol) ? "id" : idcol;
        try {
            ClassPool cp = ClassPool.getDefault();
            cp.appendClassPath(this.classroot);
            CtClass cc = cp.get(className);
            CtMethod m = cc.getDeclaredMethod(name);
            String retType = m.getReturnType().getName();
            CtClass[] paramTypes = m.getParameterTypes();
            if (paramTypes.length == 0) {
                return;
            }
            if (StringUtils.isBlank((String)param)) {
                int idPos;
                String serializableTypeName = null;
                for (CtClass ctClass : paramTypes) {
                    if (ArrayUtils.contains((Object[])this.excludeType, (Object)ctClass.getSimpleName())) continue;
                    CtClass[] inteName = ctClass.getInterfaces();
                    boolean finded = false;
                    if (inteName != null && inteName.length > 0) {
                        for (int i = 0; i < inteName.length; ++i) {
                            CtClass interclass = inteName[i];
                            if (!"java.io.Serializable".equals(interclass.getName())) continue;
                            serializableTypeName = ctClass.getName();
                            finded = true;
                            break;
                        }
                    }
                    if (finded) break;
                }
                if (StringUtils.isBlank(serializableTypeName)) {
                    serializableTypeName = retType;
                }
                if ((idPos = this.findParamIndex(idcol, m, paramTypes)) == -1) {
                    this.getLog().info((CharSequence)String.format("%s.%s\u5904\u7406\u9519\u8bef:\u6ca1\u6709\u627e\u5230\u53c2\u6570%s", className, name, idcol));
                    return;
                }
                String getKey = "String.format(\"" + key + "\",new Object[]{String.valueOf($" + idPos + ")})";
                StringBuffer buff = new StringBuffer("{");
                buff.append(String.format("Object retobj = %s.%s(%s.class,%s);", classnameGet, staticnameGet, serializableTypeName, getKey));
                buff.append("if(retobj!=null){$1=null; return (" + retType + ")retobj;}");
                buff.append("}");
                m.insertBefore(buff.toString());
                String getIdStr = "(($r)$_).get" + idcol.substring(0, 1).toUpperCase() + idcol.substring(1) + "()";
                String proKey = "String.format(\"" + key + "\",new Object[]{ " + getIdStr + "})";
                String tempStr = "{if($_!=null && $1!=null) %s.%s($_,%s);}";
                if (StringUtils.isNotBlank((String)expire)) {
                    tempStr = "{Integer expire = ($w)" + expire + "; if($_!=null && $1!=null) %s.%s($_,%s,expire);}";
                }
                m.insertAfter(String.format(tempStr, classnamePut, staticnamePut, proKey));
            } else {
                int paramPos = this.findParamIndex(param, m, paramTypes);
                if (paramPos <= 0) {
                    this.getLog().info((CharSequence)String.format("%s.%s\u5904\u7406\u9519\u8bef:\u6ca1\u6709\u627e\u5230\u53c2\u6570%s", className, name, param));
                    return;
                }
                String getIdStr = "$" + paramPos + ".get" + idcol.substring(0, 1).toUpperCase() + idcol.substring(1) + "()";
                String proKey = "String.format(\"" + key + "\",new Object[]{ " + getIdStr + "})";
                String tempStr = "{if($" + paramPos + "!=null) %s.%s($" + paramPos + ",%s);}";
                if (StringUtils.isNotBlank((String)expire)) {
                    tempStr = "{Integer expire = ($w)" + expire + "; if($" + paramPos + "!=null) %s.%s($" + paramPos + ",%s,expire);}";
                }
                m.insertAfter(String.format(tempStr, classnamePut, staticnamePut, proKey));
            }
            cc.writeFile(this.classroot);
            this.getLog().info((CharSequence)String.format("\u5904\u7406\u5b8c\u6bd5:%s.%s", className, name));
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)String.format("\u5728\u52a0\u5f3a%s\u7684%s\u65b9\u6cd5\u65f6\u51fa\u9519:%s", className, name, String.valueOf(e)));
        }
    }

    private int findParamIndex(String findParam, CtMethod m, CtClass[] paramTypes) {
        CodeAttribute codeAttribute = m.getMethodInfo().getCodeAttribute();
        LocalVariableAttribute attr = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable");
        int pos = Modifier.isStatic((int)m.getModifiers()) ? 0 : 1;
        int idPos = -1;
        for (int j = 0; j < paramTypes.length; ++j) {
            String paramName = attr.variableName(j + pos);
            if (!paramName.equalsIgnoreCase(findParam)) continue;
            idPos = j + 1;
            break;
        }
        return idPos;
    }

    private boolean checkCacheMethed(ConfigurationNode cacheNode, int i) {
        ConfigurationNode getNode = XmlUtil.getFirstNodeByNodeName((ConfigurationNode)cacheNode, (String)GET);
        ConfigurationNode putNode = XmlUtil.getFirstNodeByNodeName((ConfigurationNode)cacheNode, (String)PUT);
        if (getNode == null || putNode == null) {
            this.getLog().error((CharSequence)String.format("\u7b2c%s\u4e2aCache\u533a\u5fc5\u987b\u8981\u914d\u7f6eget\u65b9\u6cd5\u548cput\u65b9\u6cd5", i));
            return false;
        }
        String staticname1 = Addcache.findValueByAttrName(getNode, CacheColProperty.staticname);
        String classname1 = Addcache.findValueByAttrName(getNode, CacheColProperty.classname);
        String staticname2 = Addcache.findValueByAttrName(putNode, CacheColProperty.staticname);
        String classname2 = Addcache.findValueByAttrName(putNode, CacheColProperty.classname);
        if (StringUtils.isBlank((String)staticname1) || StringUtils.isBlank((String)classname1) || StringUtils.isBlank((String)staticname2) || StringUtils.isBlank((String)staticname1) || StringUtils.isBlank((String)classname2)) {
            this.getLog().error((CharSequence)String.format("\u7b2c%s\u4e2aCache\u533a\u7f3a\u5c11get\u548cput\u65b9\u6cd5\u8981\u914d\u7f6e\u597dstaticname/classname", i));
            return false;
        }
        return true;
    }

    private static final String findValueByAttrName(ConfigurationNode node, CacheColProperty colProperty) {
        return XmlUtil.findValueByAttrName((ConfigurationNode)node, (String)colProperty.name());
    }
}

