package net.wicp.tams.plugin.constant;

public enum CacheColProperty {
	classname(null, ""), id(null, ""), name(null, ""), staticname(null, ""), expire(Integer.valueOf(10000),
			"10000"), key(null, null), idcol(null, null), param(null, null);

	private Object defaultSelValue;
	private String defaultSelStringValue;

	private CacheColProperty(Object defaultSelValue, String defaultSelStringValue) {
		this.defaultSelValue = defaultSelValue;
		this.defaultSelStringValue = defaultSelStringValue;
	}

	public Object getDefaultSelValue() {
		return this.defaultSelValue;
	}

	public String getDefaultSelStringValue() {
		return this.defaultSelStringValue;
	}

	public static CacheColProperty getByName(String name) {
		for (CacheColProperty colProperty : values()) {
			if (colProperty.name().equals(name)) {
				return colProperty;
			}
		}
		return null;
	}
}