package net.wicp.tams.hibernate.add;

import org.apache.tapestry5.ioc.MappedConfiguration;
import org.apache.tapestry5.ioc.ServiceBinder;

import net.wicp.tams.hibernate.add.services.IHbService;
import net.wicp.tams.hibernate.add.services.IPageBuild;
import net.wicp.tams.hibernate.add.services.impl.HbService;
import net.wicp.tams.hibernate.add.services.impl.PageBuild;

public class LibraryModule {

	public static void contributeFactoryDefaults(
			MappedConfiguration<String, String> configuration) {
		configuration.add(HibernateAddSymbols.FIELD_NAME_PAGE, "page");
		configuration.add(HibernateAddSymbols.FIELD_NAME_ROWS, "rows");
		configuration.add(HibernateAddSymbols.FIELD_NAME_ALLNUM, "_findAllNum");
	}

	public static void bind(ServiceBinder binder) {
		binder.bind(IHbService.class, HbService.class);
		binder.bind(IPageBuild.class, PageBuild.class);
	}

}
