/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.hibernate.add.services.impl;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import net.wicp.tams.commons.web.PageAssist;
import net.wicp.tams.hibernate.add.services.IHbService;
import net.wicp.tams.hibernate.add.services.IPageBuild;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.hibernate.Criteria;
import org.hibernate.LockOptions;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Projections;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.internal.AbstractQueryImpl;
import org.slf4j.Logger;

public class HbService
implements IHbService {
    @Inject
    private Session session;
    @Inject
    private Logger logger;
    @Inject
    private IPageBuild pageBuild;

    @Override
    public <T extends Serializable> T findById(Class clazz, Serializable id) {
        return (T)((Serializable)this.session.get(clazz, id));
    }

    @Override
    public void delById(Class clazz, Serializable entityId) {
        Object entity = this.session.get(clazz, entityId);
        Preconditions.checkState((entity != null ? 1 : 0) != 0);
        this.session.delete(entity);
    }

    @Override
    public <T extends Serializable> void saveOrUpdate(T obj) {
        this.session.saveOrUpdate(obj);
    }

    @Override
    public <T extends Serializable> void attachLock(T entity) {
        try {
            this.session.buildLockRequest(LockOptions.UPGRADE).lock(entity);
        }
        catch (RuntimeException re) {
            this.logger.error("attach failed", (Throwable)re);
            throw re;
        }
    }

    @Override
    public Query getQuery(String hql) {
        return this.session.createQuery(hql);
    }

    @Override
    public Query getQuerySQL(String sql) {
        return this.session.createSQLQuery(sql);
    }

    @Override
    public <T extends Serializable> List<T> findByExample(T entity, Example.PropertySelector selector) {
        try {
            Example example = Example.create(entity).excludeZeroes();
            if (selector != null) {
                example.setPropertySelector(selector);
            }
            List results = this.session.createCriteria(entity.getClass()).add((Criterion)example).list();
            return results;
        }
        catch (RuntimeException re) {
            this.logger.error("find by example failed", (Throwable)re);
            throw re;
        }
    }

    @Override
    public <T extends Serializable> List<T> findByExample(T entity, String ... excludes) {
        try {
            Example example = Example.create(entity).excludeZeroes();
            if (ArrayUtils.isNotEmpty((Object[])excludes)) {
                for (String proName : excludes) {
                    example.excludeProperty(proName);
                }
            }
            List results = this.session.createCriteria(entity.getClass()).add((Criterion)example).list();
            return results;
        }
        catch (RuntimeException re) {
            this.logger.error("find by example failed", (Throwable)re);
            throw re;
        }
    }

    @Override
    public PageAssist findByCriteriaPage(Criteria criteria, PageAssist pageAssist) {
        PageAssist pageAssistTrue;
        PageAssist pageAssist2 = pageAssistTrue = pageAssist == null ? this.pageBuild.build() : pageAssist;
        if (pageAssistTrue.getAllNum() < 0L) {
            long totalCount = (Long)criteria.setProjection(Projections.rowCount()).uniqueResult();
            pageAssistTrue.setAllNum(totalCount);
            criteria.setProjection(null);
        }
        List retlist = this.findByCriteriaPage(criteria, pageAssistTrue.getPageNo(), pageAssistTrue.getPageSize());
        pageAssistTrue.setResult(retlist);
        return pageAssistTrue;
    }

    @Override
    public PageAssist findByCriteriaPage(Criteria criteria) {
        return this.findByCriteriaPage(criteria, null);
    }

    @Override
    public PageAssist findByQueryPage(Query queryparam, PageAssist pageAssistparam) {
        PageAssist pageAssistTrue = pageAssistparam == null ? this.pageBuild.build() : pageAssistparam;
        int pageSize = pageAssistTrue.getPageSize();
        int pageNo = pageAssistTrue.getPageNo();
        long allNum = pageAssistTrue.getAllNum();
        Preconditions.checkState((queryparam != null && pageNo > 0 && pageSize > 0 ? 1 : 0) != 0);
        AbstractQueryImpl queryAbs = (AbstractQueryImpl)queryparam;
        if (allNum < 0L) {
            String queryStr = queryparam.getQueryString();
            int firstIndex = queryStr.indexOf(" from");
            String queryCountSql = "select COUNT(-1)  " + queryStr.substring(firstIndex);
            Query countQuery = this.session.createQuery(queryCountSql);
            try {
                if (ArrayUtils.isNotEmpty((Object[])queryAbs.getNamedParameters())) {
                    Map paramMap = (Map)PropertyUtils.getProperty((Object)queryAbs, (String)"namedParameters");
                    for (String paramName : queryAbs.getNamedParameters()) {
                        TypedValue tempobj = (TypedValue)paramMap.get(paramName);
                        countQuery.setParameter(paramName, tempobj.getValue(), tempobj.getType());
                    }
                } else {
                    List values = (List)PropertyUtils.getProperty((Object)queryAbs, (String)"values");
                    for (int i = 0; i < values.size(); ++i) {
                        countQuery.setParameter(i + 1, values.get(i));
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("Query\u5728\u7ffb\u9875\u65f6\u67e5\u8be2\u603b\u8bb0\u5f55\u6570\u51fa\u9519\u3002", (Throwable)e);
            }
            allNum = (Long)countQuery.uniqueResult();
            pageAssistTrue.setAllNum(allNum);
        }
        int startRes = pageSize * (pageNo - 1);
        int endRes = (int)(allNum > 0L && allNum < (long)(pageSize * pageNo) ? allNum : (long)(pageSize * pageNo));
        queryparam.setFirstResult(startRes).setMaxResults(endRes);
        List queryList = queryparam.list();
        pageAssistTrue.setResult(queryList);
        return pageAssistTrue;
    }

    @Override
    public PageAssist findByQueryPage(Query queryparam) {
        return this.findByQueryPage(queryparam, null);
    }

    private final <T extends Serializable> List<T> findByCriteriaPage(Criteria criteria, int pageNo, int pageSize) {
        Preconditions.checkState((criteria != null && pageNo > 0 && pageSize > 0 ? 1 : 0) != 0);
        int min = (pageNo - 1) * pageSize;
        criteria.setFirstResult(min).setMaxResults(pageSize);
        return criteria.list();
    }
}

