package net.wicp.tams.hibernate.add.services.impl;

import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.Request;

import net.wicp.tams.commons.apiext.StringUtil;
import net.wicp.tams.commons.web.PageAssist;
import net.wicp.tams.hibernate.add.HibernateAddSymbols;
import net.wicp.tams.hibernate.add.services.IPageBuild;

public class PageBuild implements IPageBuild {

	@Inject
	protected Request request;

	private final String fieldName_page;

	private final String fieldName_rows;

	private final String fieldName_allNum;

	public PageBuild(
			@Symbol(HibernateAddSymbols.FIELD_NAME_PAGE) String fieldName_page,
			@Symbol(HibernateAddSymbols.FIELD_NAME_ROWS) String fieldName_rows,
			@Symbol(HibernateAddSymbols.FIELD_NAME_ALLNUM) String fieldName_allNum) {
		this.fieldName_page = fieldName_page;
		this.fieldName_rows = fieldName_rows;
		this.fieldName_allNum = fieldName_allNum;
	}

	public PageAssist build() {
		String page = request.getParameter(fieldName_page);
		String rows = request.getParameter(fieldName_rows);
		String allNumStr = request.getParameter(fieldName_allNum);
		int pageNo = StringUtil.isNull(page) ? 1 : Integer.parseInt(page);
		int rowsNum = StringUtil.isNull(rows) ? 10 : Integer.parseInt(rows);
		int allNum = StringUtil.isNull(allNumStr) ? -1 : Integer
				.parseInt(allNumStr);
		return new PageAssist(rowsNum, pageNo, allNum);
	}

	public PageAssist build(int pageSize, int pageNo) {
		return new PageAssist(pageSize, pageNo, -1);
	}

	public PageAssist build(int pageSize, int pageNo, int allNum) {
		return new PageAssist(pageSize, pageNo, allNum);
	}

}
