package net.wicp.tams.hibernate.add.services.impl;

import static org.hibernate.criterion.Example.create;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.hibernate.Criteria;
import org.hibernate.LockOptions;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Example.PropertySelector;
import org.hibernate.criterion.Projections;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.internal.AbstractQueryImpl;
import org.slf4j.Logger;

import com.google.common.base.Preconditions;

import net.wicp.tams.commons.web.PageAssist;
import net.wicp.tams.hibernate.add.services.IHbService;
import net.wicp.tams.hibernate.add.services.IPageBuild;

@SuppressWarnings({ "rawtypes", "unchecked" })
public class HbService implements IHbService {
	@Inject
	private Session session;
	@Inject
	private Logger logger;
	@Inject
	private IPageBuild pageBuild;

	public <T extends Serializable> T findById(Class clazz, Serializable id) {
		return (T) session.get(clazz, id);
	}

	public void delById(Class clazz, Serializable entityId) {
		Object entity = session.get(clazz, entityId);
		Preconditions.checkState(entity != null);
		session.delete(entity);
	}

	public <T extends Serializable> void saveOrUpdate(T obj) {
		session.saveOrUpdate(obj);
	}

	public <T extends Serializable> void attachLock(T entity) {
		try {
			session.buildLockRequest(LockOptions.UPGRADE).lock(entity);
		} catch (RuntimeException re) {
			logger.error("attach failed", re);
			throw re;
		}
	}

	public Query getQuery(String hql) {
		return session.createQuery(hql);
	}

	public Query getQuerySQL(String sql) {
		return session.createSQLQuery(sql);
	}

	public <T extends Serializable> List<T> findByExample(T entity, PropertySelector selector) {
		try {
			Example example = create(entity).excludeZeroes();
			if (selector != null) {
				example.setPropertySelector(selector);
			}
			List<T> results = (List<T>) session.createCriteria(entity.getClass()).add(example).list();
			return results;
		} catch (RuntimeException re) {
			logger.error("find by example failed", re);
			throw re;
		}
	}

	public <T extends Serializable> List<T> findByExample(T entity, String... excludes) {
		try {
			Example example = create(entity).excludeZeroes();
			if (ArrayUtils.isNotEmpty(excludes)) {
				for (String proName : excludes) {
					example.excludeProperty(proName);
				}
			}
			List<T> results = (List<T>) session.createCriteria(entity.getClass()).add(example).list();
			return results;
		} catch (RuntimeException re) {
			logger.error("find by example failed", re);
			throw re;
		}
	}

	public PageAssist findByCriteriaPage(Criteria criteria, PageAssist pageAssist) {
		PageAssist pageAssistTrue = pageAssist == null ? pageBuild.build() : pageAssist;
		if (pageAssistTrue.getAllNum() < 0) {
			long totalCount = ((Long) criteria.setProjection(Projections.rowCount()).uniqueResult()).longValue();
			pageAssistTrue.setAllNum(totalCount);
			criteria.setProjection(null);
		}

		List<?> retlist = findByCriteriaPage(criteria, pageAssistTrue.getPageNo(), pageAssistTrue.getPageSize());
		pageAssistTrue.setResult(retlist);
		return pageAssistTrue;
	}

	public PageAssist findByCriteriaPage(Criteria criteria) {
		return findByCriteriaPage(criteria, null);
	}

	public PageAssist findByQueryPage(Query queryparam, PageAssist pageAssistparam) {
		PageAssist pageAssistTrue = pageAssistparam == null ? pageBuild.build() : pageAssistparam;
		int pageSize = pageAssistTrue.getPageSize();
		int pageNo = pageAssistTrue.getPageNo();
		long allNum = pageAssistTrue.getAllNum();
		Preconditions.checkState(queryparam != null && pageNo > 0 && pageSize > 0);
		AbstractQueryImpl queryAbs = (AbstractQueryImpl) queryparam;

		if (allNum < 0) {// 需要查询记录数
			String queryStr = queryparam.getQueryString();
			int firstIndex = queryStr.indexOf(" from");
			String queryCountSql = "select COUNT(-1)  " + queryStr.substring(firstIndex);
			Query countQuery = session.createQuery(queryCountSql);

			try {
				if (ArrayUtils.isNotEmpty(queryAbs.getNamedParameters())) {
					Map<String, TypedValue> paramMap = (Map<String, TypedValue>) PropertyUtils.getProperty(queryAbs,
							"namedParameters");
					for (String paramName : queryAbs.getNamedParameters()) {
						TypedValue tempobj = paramMap.get(paramName);
						countQuery.setParameter(paramName, tempobj.getValue(), tempobj.getType());
					}
				} else {
					List values = (List) PropertyUtils.getProperty(queryAbs, "values");
					for (int i = 0; i < values.size(); i++) {
						countQuery.setParameter(i + 1, values.get(i));
					}
				}
			} catch (Exception e) {
				logger.error("Query在翻页时查询总记录数出错。", e);
			}

			allNum = ((Long) countQuery.uniqueResult()).longValue();
			pageAssistTrue.setAllNum(allNum);
		}
		int startRes = pageSize * (pageNo - 1);
		int endRes = (int) ((allNum > 0 && allNum < pageSize * pageNo) ? allNum : pageSize * pageNo);
		queryparam.setFirstResult(startRes).setMaxResults(endRes);
		List queryList = queryparam.list();
		pageAssistTrue.setResult(queryList);
		return pageAssistTrue;
	}

	public PageAssist findByQueryPage(Query queryparam) {
		return findByQueryPage(queryparam, null);
	}

	// ///////////////////////////////////////////////////////////////////////////////
	private final <T extends Serializable> List<T> findByCriteriaPage(Criteria criteria, int pageNo, int pageSize) {
		Preconditions.checkState(criteria != null && pageNo > 0 && pageSize > 0);
		int min = (pageNo - 1) * pageSize;
		criteria.setFirstResult(min).setMaxResults(pageSize);
		return criteria.list();
	}

}
