/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.component.services.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.wicp.tams.component.services.ISupportedLocales;
import net.wicp.tams.component.tools.TapestryAssist;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.dom.Document;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.internal.services.DocumentLinker;
import org.apache.tapestry5.internal.services.ModuleInitsManager;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.services.javascript.InitializationPriority;
import org.apache.tapestry5.services.javascript.ModuleConfigurationCallback;
import org.apache.tapestry5.services.javascript.ModuleManager;
import org.apache.tapestry5.services.javascript.StylesheetLink;

public class JqDocLinkerImpl
implements DocumentLinker {
    private final List<String> coreLibraryURLs = CollectionFactory.newList();
    private final List<String> libraryURLs = CollectionFactory.newList();
    private final Set<String> htmlLibraryURLs = CollectionFactory.newSet();
    private final ModuleInitsManager initsManager = new ModuleInitsManager();
    private final List<ModuleConfigurationCallback> moduleConfigurationCallbacks = CollectionFactory.newList();
    private final List<StylesheetLink> includedStylesheets = CollectionFactory.newList();
    private final ModuleManager moduleManager;
    private final boolean omitGeneratorMetaTag;
    private final String contextPath;
    private final String rjzjhjsclientpath;
    private final ISupportedLocales supportedLocales;
    private final String tapestryBanner;
    private boolean hasScriptsOrInitializations;

    public JqDocLinkerImpl(ModuleManager moduleManager, boolean omitGeneratorMetaTag, String tapestryVersion, String contextPath, String rjzjhjsclientpath, ISupportedLocales supportedLocales) {
        this.moduleManager = moduleManager;
        this.omitGeneratorMetaTag = omitGeneratorMetaTag;
        this.contextPath = contextPath;
        this.rjzjhjsclientpath = rjzjhjsclientpath;
        this.supportedLocales = supportedLocales;
        this.tapestryBanner = String.format("Apache Tapestry Framework (version %s)", tapestryVersion);
    }

    public void addStylesheetLink(StylesheetLink sheet) {
        this.includedStylesheets.add(sheet);
    }

    public void addCoreLibrary(String libraryURL) {
        this.coreLibraryURLs.add(libraryURL);
        this.hasScriptsOrInitializations = true;
    }

    public void addHtmlLibrary(String libraryURL) {
        this.htmlLibraryURLs.add(libraryURL);
        this.hasScriptsOrInitializations = true;
    }

    public void addLibrary(String libraryURL) {
        this.libraryURLs.add(libraryURL);
        this.hasScriptsOrInitializations = true;
    }

    public void addScript(InitializationPriority priority, String script) {
        this.addInitialization(priority, "t5/core/pageinit", "evalJavaScript", new JSONArray().put((Object)script));
    }

    public void addInitialization(InitializationPriority priority, String moduleName, String functionName, JSONArray arguments) {
        this.initsManager.addInitialization(priority, moduleName, functionName, arguments);
        this.hasScriptsOrInitializations = true;
    }

    public void updateDocument(Document document) {
        Element root = document.getRootElement();
        if (root == null) {
            return;
        }
        this.addStylesheetsToHead(root, this.includedStylesheets);
        boolean isHtmlRoot = root.getName().equals("html");
        if (!this.omitGeneratorMetaTag && isHtmlRoot) {
            Element head = this.findOrCreateElement(root, "head", true);
            Element existingMeta = head.find("meta");
            JqDocLinkerImpl.addElementBefore(head, existingMeta, "meta", "name", "generator", "content", this.tapestryBanner);
        }
        this.addScriptElements(root);
    }

    private static Element addElementBefore(Element container, Element insertionPoint, String name, String ... namesAndValues) {
        if (insertionPoint == null) {
            return container.element(name, namesAndValues);
        }
        return insertionPoint.elementBefore(name, namesAndValues);
    }

    private void addScriptElements(Element root) {
        Element body;
        String rootElementName = root.getName();
        Element element = body = rootElementName.equals("html") ? this.findOrCreateElement(root, "body", false) : null;
        if (body != null) {
            body.attribute("data-page-initialized", Boolean.toString(!this.hasScriptsOrInitializations));
        }
        if (!this.hasScriptsOrInitializations) {
            return;
        }
        if (!rootElementName.equals("html")) {
            throw new RuntimeException(String.format("The root element of the rendered document was <%s>, not <html>. A root element of <html> is needed when linking JavaScript and stylesheet resources.", rootElementName));
        }
        Element head = this.findOrCreateElement(root, "head", true);
        this.addScriptsToEndOfHead(head);
    }

    private Element findOrCreateElement(Element root, String childElement, boolean atTop) {
        Element container = root.find(childElement);
        if (container == null) {
            container = atTop ? root.elementAt(0, childElement, new String[0]) : root.element(childElement, new String[0]);
        }
        return container;
    }

    protected void addScriptsToEndOfHead(Element head) {
        Element div = head.element("div", new String[0]);
        div.moveToTop(head);
        this.moduleManager.writeConfiguration(div, this.moduleConfigurationCallbacks);
        div.element("script", new String[]{"type", "text/javascript"}).text(String.format("window.contextpath='%s';window.lan='%s';window.rjzjhjs='%s';window.ajaxcontext='%s'", this.contextPath, this.supportedLocales.getCurLocale(), this.rjzjhjsclientpath, TapestryAssist.getAjaxContext(this.contextPath)));
        for (String url : this.coreLibraryURLs) {
            div.element("script", new String[]{"type", "text/javascript", "src", url});
        }
        for (String url : this.libraryURLs) {
            div.element("script", new String[]{"type", "text/javascript", "src", url});
        }
        for (String url : this.htmlLibraryURLs) {
            div.element("script", new String[]{"type", "text/javascript", "src", url});
        }
        this.moduleManager.writeInitialization(div, new ArrayList(), this.initsManager.getSortedInits());
    }

    private static Element createTemporaryContainer(Element headElement, String existingElementName, String newElementName) {
        Element existingScript = headElement.find(existingElementName);
        return JqDocLinkerImpl.addElementBefore(headElement, existingScript, newElementName, new String[0]);
    }

    protected void addStylesheetsToHead(Element root, List<StylesheetLink> stylesheets) {
        int count = stylesheets.size();
        if (count == 0) {
            return;
        }
        String rootElementName = root.getName();
        if (!rootElementName.equals("html")) {
            return;
        }
        Element head = this.findOrCreateElement(root, "head", true);
        Element container = JqDocLinkerImpl.createTemporaryContainer(head, "style", "stylesheet-container");
        for (int i = 0; i < count; ++i) {
            stylesheets.get(i).add(container);
        }
        container.pop();
    }

    public void addModuleConfigurationCallback(ModuleConfigurationCallback callback) {
        assert (callback != null);
        this.moduleConfigurationCallbacks.add(callback);
    }
}

