/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.component.services.base;

import net.wicp.tams.component.annotation.HtmlJs;
import net.wicp.tams.component.constant.EasyUIAdd;
import net.wicp.tams.component.services.ISupportedLocales;
import net.wicp.tams.component.services.impl.JqDocLinkerImpl;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.tapestry5.annotations.SetupRender;
import org.apache.tapestry5.http.services.RequestGlobals;
import org.apache.tapestry5.internal.services.DocumentLinker;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.MethodAdvice;
import org.apache.tapestry5.plastic.MethodInvocation;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticMethod;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.Environment;
import org.apache.tapestry5.services.TransformConstants;
import org.apache.tapestry5.services.javascript.InitializationPriority;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.apache.tapestry5.services.transform.TransformationSupport;

public class PageWorker
implements ComponentClassTransformWorker2 {
    private final AssetSource assetSource;
    private final JavaScriptSupport javaScriptSupport;
    private final String contextPath;
    private final RequestGlobals requestGlobals;
    private final ISupportedLocales supportedLocales;
    private final Environment environment;
    private final String easyuipath;
    private final String rjzjhpath;

    public PageWorker(AssetSource assetSource, JavaScriptSupport javaScriptSupport, RequestGlobals requestGlobals, Environment environment, @Symbol(value="tapestry.context-path") String contextPath, @Symbol(value="path.comassets") String rjzjhpath, @Symbol(value="path.easyui") String easyuipath, ISupportedLocales supportedLocales) {
        this.easyuipath = easyuipath;
        this.assetSource = assetSource;
        this.javaScriptSupport = javaScriptSupport;
        this.contextPath = contextPath;
        this.supportedLocales = supportedLocales;
        this.environment = environment;
        this.rjzjhpath = rjzjhpath;
        this.requestGlobals = requestGlobals;
    }

    public void transform(PlasticClass plasticClass, TransformationSupport support, MutableComponentModel model) {
        PlasticMethod setupRender = plasticClass.introduceMethod(TransformConstants.SETUP_RENDER_DESCRIPTION);
        model.enableSupportsInformalParameters();
        final HtmlJs htmlJs = (HtmlJs)plasticClass.getAnnotation(HtmlJs.class);
        if (htmlJs != null) {
            setupRender.addAdvice(new MethodAdvice(){

                public void advise(MethodInvocation invocation) {
                    JqDocLinkerImpl linker = (JqDocLinkerImpl)PageWorker.this.environment.peekRequired(DocumentLinker.class);
                    if (ArrayUtils.isNotEmpty((Object[])htmlJs.turl())) {
                        for (String string : htmlJs.turl()) {
                            String urlTrue = PageWorker.this.assetSource.getExpandedAsset(string).toClientURL();
                            linker.addHtmlLibrary(urlTrue);
                        }
                    }
                    if (ArrayUtils.isNotEmpty((Object[])htmlJs.url())) {
                        for (String string : htmlJs.url()) {
                            linker.addHtmlLibrary(string);
                        }
                    }
                    if (ArrayUtils.isNotEmpty((Object[])htmlJs.easyuiadd())) {
                        for (EasyUIAdd easyUIAdd : htmlJs.easyuiadd()) {
                            String addUrl = String.format("%s/%s", PageWorker.this.easyuipath, easyUIAdd.getJsName());
                            linker.addHtmlLibrary(PageWorker.this.assetSource.getExpandedAsset(addUrl).toClientURL());
                        }
                    }
                    invocation.proceed();
                }
            });
        }
        if (model.isPage()) {
            setupRender.addAdvice(new MethodAdvice(){

                public void advise(MethodInvocation invocation) {
                    PageWorker.this.javaScriptSupport.require("init").invoke("initGlobal").priority(InitializationPriority.LATE).with(new Object[]{new JSONObject()});
                    PageWorker.this.javaScriptSupport.importJavaScriptLibrary(PageWorker.this.assetSource.getExpandedAsset(PageWorker.this.rjzjhpath + "/config.js").toClientURL());
                    invocation.proceed();
                }
            });
        }
        model.addRenderPhase(SetupRender.class);
    }
}

