package net.wicp.tams.component.response;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.http.services.Response;

import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.constant.ContentType;

public class FileStreamResponse implements StreamResponse {
	private final String fileName;
	private final byte[] byteAry;
	private final ContentType contentType;

	public FileStreamResponse(File file, String fileName) throws IOException {
		this(new FileInputStream(file), fileName);
	}

	public FileStreamResponse(File file) throws IOException {
		this(file, file.getName());
	}

	public FileStreamResponse(InputStream inputStream, String fileName) throws IOException {
		byte[] slurpbyte = IOUtil.slurpbyte(inputStream);
		inputStream.close();// 是关闭流？
		this.fileName = fileName;
		this.byteAry = slurpbyte;
		this.contentType = ContentType.bin;
	}

	public FileStreamResponse(InputStream inputStream) throws IOException {
		this(inputStream, "下载文件");
	}

	public FileStreamResponse(byte[] byteAry, String fileName) {
		this.fileName = fileName;
		this.byteAry = byteAry;
		this.contentType = ContentType.bin;
	}

	public FileStreamResponse(byte[] byteAry, String fileName, ContentType contentType) {
		this.fileName = fileName;
		this.byteAry = byteAry;
		this.contentType = contentType;
	}

	@Override
	public String getContentType() {
		return contentType.getValue();
	}

	@Override
	public InputStream getStream() throws IOException {
		return new ByteArrayInputStream(this.byteAry);
	}

	@Override
	public void prepareResponse(Response response) {
		response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
	}
}
