package net.wicp.tams.component.pages;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.ServletContext;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.tapestry5.annotations.OnEvent;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.upload.services.UploadedFile;
import org.apache.tapestry5.util.TextStreamResponse;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.annotation.TamsBean;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.json.EasyUiAssist;
import net.wicp.tams.common.apiext.json.IQueryAssetInfo;
import net.wicp.tams.common.beans.QueryAssetInfo;
import net.wicp.tams.common.callback.IConvertValue;
import net.wicp.tams.common.constant.PathType;
import net.wicp.tams.component.SymbolConstantsCus;
import net.wicp.tams.component.components.Upload;
import net.wicp.tams.component.tools.TapestryAssist;

@Slf4j
public abstract class ParentPageBean<T> extends ParentPage {
	@SuppressWarnings("unchecked")
	public Class<T> getTClass() {
		Class<T> tClass = (Class<T>) ((ParameterizedType) getClass().getGenericSuperclass())
				.getActualTypeArguments()[0];
		return tClass;
	}
	
	
	//得到url地址的前缀。由于某些情况下(如提交文件的form)必须要采用https.而相对地址是http。
	public String getUrlPre() {
		return TapestryAssist.getAjaxContext(super.contextPath);		
	}

	/**
	 * 只有一个入口,不能被覆盖
	 * 
	 * 默认的转换器，由注解方式生成。如果没使用注解方式，覆盖这个方法。L:所有列名 M:别名集合，R：转换器
	 * 
	 * @return
	 */
	protected final QueryAssetInfo queryAssetInfo() {
		return EasyUiAssist.getQueryAssetInfo(getTClass(), cusQueryAssetInfo(), getAnnotationContext());
	}

	/***
	 * 子类可以覆盖它来 做自己的convert
	 * 
	 * @return
	 */
	@OnEvent(value = SymbolConstantsCus.EVENT_QueryAlisConvert)
	protected IQueryAssetInfo cusQueryAssetInfo() {
		return new IQueryAssetInfo() {

			@SuppressWarnings("rawtypes")
			@Override
			public Map<String, IConvertValue> queryAlisConvert() {
				return new HashMap<String, IConvertValue>();
			}
		};
	};

	protected Pair<List<Field>, List<Field>> querySaveInfo = "net.wicp.tams.component.pages.ParentPageRest".equals(
			getClass().getGenericSuperclass().getTypeName()) ? null : EasyUiAssist.getQuerySaveInfo(getTClass());

	public String getCols() {
		return queryAssetInfo().getGridTitleCols();
	}

	// 子类可以覆盖,每个页面可以设置自己的文件上传相对路径,默认是上传文件的根路径
	protected String getUploadRelaPath() {
		return "/";
	};

	@Property
	private TamsBean tamsbean = "net.wicp.tams.component.pages.ParentPageRest"
			.equals(getClass().getGenericSuperclass().getTypeName()) ? null : getTClass().getAnnotation(TamsBean.class);

	protected  T t = "net.wicp.tams.component.pages.ParentPageRest"
			.equals(getClass().getGenericSuperclass().getTypeName()) ? null : TapestryAssist.getBeanFromPage(getTClass(), requestGlobals);

	@Inject
	@Symbol(SymbolConstantsCus.PATH_FILE_UPLOAD_DIR)
	protected String defaultUploadDir;// 默认的文件上传目录,在service里配置

	/**
	 * 得到上传文件的操作系统的地址
	 * 
	 * @param relapath
	 * @return
	 */
	public final String getOsDir(String relapath) {
		return PathType.getPath(IOUtil.mergeFolderAndFilePath(defaultUploadDir, relapath));
	}

	public TextStreamResponse onSave() {
		final T saveBean = TapestryAssist.getBeanFromPage(getTClass(), requestGlobals);
		String id = request.getParameter("id");
		// 处理文件上传组件
		String fieldName = request.getParameter(Upload.fixfieldname);
		if (StringUtil.isNotNull(fieldName)) {//
			List<UploadedFile> fileList = req.getUploadFileList();
			if (CollectionUtils.isNotEmpty(fileList)) {
				try {
					String lastFileName = saveUpload(getUploadRelaPath(), fileList.get(0));
					// 只处理一个文件，大部分是这种情况
					PropertyUtils.setProperty(saveBean, fieldName.substring(0, fieldName.length() - 5), lastFileName);
				} catch (Throwable e) {
					return TapestryAssist.getTextStreamResponse(Result.getError(e.getMessage()));
				}
			}
		}
		// end 处理文件上传组件
		boolean isInsert = false;
		if (StringUtil.isNull(id)) {
			isInsert = true;
		} else {
			isInsert = false;
		}
		try {
			doSave(saveBean, isInsert);
		} catch (Throwable e) {
			log.error("save data error", e);
			return TapestryAssist.getTextStreamResponse(Result.getError(e.getMessage()));
		}
		return TapestryAssist.getTextStreamResponse(Result.getSuc());
	}

	/***
	 * 默认的保存方案，只支持保存一个文件
	 * 
	 * @param uploadRelaDir 上传的相对目录
	 * @param uploadedFile  上传的文件
	 * @return 保存后的文件名
	 */
	public String saveUpload(String uploadRelaDir, UploadedFile uploadedFile) {
		List<UploadedFile> list = new ArrayList<UploadedFile>();
		list.add(uploadedFile);
		List<File> saveUploads = req.saveUpload(uploadRelaDir, list);
		List<String> retlist = saveUploads.stream().map(e -> e.getName()).collect(Collectors.toList());
		return retlist.get(0);
	}

	public TextStreamResponse onDel() {
		String id = request.getParameter("id");
		if (StringUtil.isNull(id)) {
			return TapestryAssist.getTextStreamResponse(Result.getSuc("没有拿到id，不能进行删除"));
		}
		try {
			doDel(id);
		} catch (Throwable e) {
			log.error("delete data error", e);
			return TapestryAssist.getTextStreamResponse(Result.getError(e.getMessage()));
		}
		return TapestryAssist.getTextStreamResponse(Result.getSuc());
	}

	public String getUrl() {
		ServletContext servletContext = requestGlobals.getHTTPServletRequest().getServletContext();
		return TapestryAssist.urlBean(componentClassResolver, getClass(), this.tamsbean, null, null,
				getAnnotationContext());
//		String retUrl = tamsbean.url();
//		if (StringUtil.isNull(retUrl)) {
//			// 页面所在的类名
//			String name = getClass().getName();
//			String initParameter = servletContext.getInitParameter("tapestry.app-package");
//			retUrl = name.replace(initParameter + ".pages", "").replace(".", "/");
//		}
//		return retUrl;
	}

	// 默认的contextmap,避免每个子页面都定义它
	public Map<String, String> getAnnotationContext() {
		return new HashMap<String, String>();
	}

	public abstract void doSave(T t, boolean isInsert);

	public abstract void doDel(String id);

}
