package net.wicp.tams.component.components;

import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.AfterRenderTemplate;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.commons.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;


import net.wicp.tams.common.apiext.StringUtil;

@Import(stack = "codemirror")
public class Yaml {
	@Inject
	private JavaScriptSupport support;
	@Inject
	private ComponentResources resources;
	@Inject
	private Messages messages;// 国际化

	@Parameter(defaultPrefix = BindingConstants.LITERAL)
	private String id;

	@Parameter(defaultPrefix = BindingConstants.LITERAL)
	@Property
	private String name;
	
	
	@Parameter(defaultPrefix = BindingConstants.LITERAL)
	private String value;//初始值
	

	@AfterRenderTemplate
	void afterRenderTemplate() {
		JSONObject spec = new JSONObject();
		spec.put("id", getId());// 注意与页面上的file组件的id一致
		if (resources.isBound("value")) {
			spec.put("value", value);
		}		
		support.require("init").invoke("yaml").with(spec);
	}



	/***
	 * 得到id
	 * 
	 * @return
	 */
	public String getId() {
		if (!resources.isBound("id") && StringUtil.isNull(id)) {
			id = support.allocateClientId(resources);
		}
		return this.id;
	}
}
