package net.wicp.tams.component.components;

import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.json.JSONObject;

import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.constant.StrPattern;
import net.wicp.tams.component.components.base.BaseValidateBox;

/***
 * 验证组件
 * 
 * @author andy.zhou
 *
 */
@Import(stack = "easyuistack")
public class ValidateBox extends BaseValidateBox {

	/***
	 * 传入strpattern类的元素
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private StrPattern strpattern;

	@Override
	protected void packParms(JSONObject spec) {
		super.packParms(spec);
		spec.put("class", "validatebox");
		if (resources.isBound("strpattern") && strpattern != null && StrPattern.no != strpattern) {// no代表不验证
			JSONObject params = spec.getJSONObject("params");
			// StrPattern pattern = StrPattern.valueOf(strpattern);
			String replace = strpattern.getCode().replace("\\", "\\\\");// 反斜杠需要加转义。
			params.put("validType", String.format("validatestr['%s','%s']", replace, strpattern.getMessage()));
		}
		spec.put("ishtml", true);
	}

	boolean beforeRenderBody() {
		return false;
	}

}
