package net.wicp.tams.component.components;

import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.BeginRender;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

import net.wicp.tams.component.components.base.BaseProjectComponent;

/***
 * TreeGrid组件（数据结构与tree类似，不与datagrid类似）
 * 
 * @author andy.zhou
 *
 */
@Import(stack = "easyuistack")
public class TreeGrid extends BaseProjectComponent {
	/***
	 * 取数据的地址， 路径不用带contextpath.
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private String url;

	@Environmental
	protected JavaScriptSupport javaScriptSupport;

	/***
	 * 与url配套使用，在url后面添加查询参数
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private JSONObject queryParams;

	/***
	 * 发送请求的方法，默认是post
	 */
	@Parameter(required = false, value = "post", defaultPrefix = BindingConstants.LITERAL)
	private String method;

	/*****
	 * 是否要渐变显示
	 */
	@Parameter(required = false, value = "false", defaultPrefix = BindingConstants.LITERAL)
	private boolean animate;

	/*****
	 * 是否显示checkbox
	 */
	@Parameter(required = false, value = "false", defaultPrefix = BindingConstants.LITERAL)
	private boolean checkbox;

	/*****
	 * 是否级联显示check
	 */
	@Parameter(required = false, value = "true", defaultPrefix = BindingConstants.LITERAL)
	private boolean cascadeCheck;

	/*****
	 * 是否仅在叶子节点显示check
	 */
	@Parameter(required = false, value = "false", defaultPrefix = BindingConstants.LITERAL)
	private boolean onlyLeafCheck;

	/*****
	 * 是否显示树的虚线
	 */
	@Parameter(required = false, value = "false", defaultPrefix = BindingConstants.LITERAL)
	private boolean lines;

	/*****
	 * 是否能拖拽
	 */
	@Parameter(required = false, value = "false", defaultPrefix = BindingConstants.LITERAL)
	private boolean dnd;
	/***
	 * 树的静态数据，有了它就无需url查询了
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private JSONArray data;
	/****
	 * 节点text的显示格式
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private String formatter;

	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private JSONObject params;// 其它附加参数
	
	
	
	
	/////////////////////////////////////以下是多加的字段/////////////////////////////////////////////////////
	/****
	 * 列定义
	 */
	@Parameter(required = true, defaultPrefix = BindingConstants.LITERAL)
	private JSONArray columns;
	/***
	 * id
	 */
	@Parameter(required = false, value = "id", defaultPrefix = BindingConstants.LITERAL)
	private String idField;
	/***
	 * text
	 */
	@Parameter(required = false, value = "text", defaultPrefix = BindingConstants.LITERAL)
	private String treeField;
	
	/***
	 * 是否要显示行号
	 */
	@Parameter(required = false, value = "true", defaultPrefix = BindingConstants.LITERAL)
	private boolean rownumbers;
	

	@BeginRender
	void begin(MarkupWriter writer) {
		// spec组装
		JSONObject spec = new JSONObject();
		spec.put("id", getId());
		if (resources.isBound("formatter"))
			spec.put("opFormatter", formatter);
		// params组装
		if (!resources.isBound("params")) {
			params = new JSONObject();
		}
		spec.put("columns", columns);
		spec.put("params", params);
		params.put("idField", idField);
		params.put("treeField", treeField);
		params.put("rownumbers", rownumbers);
		
		
		if (resources.isBound("method"))
			params.put("method", method);
		if (resources.isBound("animate"))
			params.put("animate", animate);
		if (resources.isBound("checkbox"))
			params.put("checkbox", checkbox);
		if (resources.isBound("cascadeCheck"))
			params.put("cascadeCheck", cascadeCheck);
		if (resources.isBound("onlyLeafCheck"))
			params.put("onlyLeafCheck", onlyLeafCheck);
		if (resources.isBound("lines"))
			params.put("lines", lines);
		if (resources.isBound("dnd"))
			params.put("dnd", lines);
		if (resources.isBound("data")) {
			params.put("data", data);
		} else {
			String urlTrue = url;
			if (resources.isBound("url")) {
				if (resources.isBound("queryParams")) {// 查询参数
					StringBuffer buffer = new StringBuffer("?");
					for (String key : queryParams.keys()) {
						buffer.append(key + "=" + queryParams.getString(key) + "&");
					}
					urlTrue = url + buffer.substring(0, buffer.length() - 1);
				}
			}
			params.put("url", supportedLocales.buildUrl(urlTrue));
		}

		Element element = writer.element("ul", "id", getId());
		resources.renderInformalParameters(writer);// rend非标准参数
		writer.end();

		javaScriptSupport.require("init").invoke("treegrid").with(spec);
	}

}
