package net.wicp.tams.component.components;

import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.Events;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.commons.Messages;
import org.apache.tapestry5.http.Link;
import org.apache.tapestry5.http.services.Request;
import org.apache.tapestry5.internal.util.CaptureResultCallback;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;

import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.component.SymbolConstantsCus;
import net.wicp.tams.component.components.base.BaseProjectComponent;
import net.wicp.tams.component.tools.TapestryAssist;

@Events({ SymbolConstantsCus.EVENT_SAVESEL })
public class DialogTree extends BaseProjectComponent {
	/***
	 * 树需要load数据的url 取数据的地址， 路径不用带contextpath.
	 */
	@Parameter(required = true, defaultPrefix = BindingConstants.LITERAL)
	@Property
	private String treeLoadUrl;

	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	@Property
	private String title;

	@Parameter(required = false, value = "false", defaultPrefix = BindingConstants.LITERAL)
	@Property
	private boolean onlyLeafCheck;
	/***
	 * 初始化数据，适合那种不用做ajax更新树的情况
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	@Property
	private JSONArray initData = new JSONArray();

	@Parameter(required = false, value = "400", defaultPrefix = BindingConstants.LITERAL)
	@Property
	protected Integer width;

	@Parameter(required = false, value = "300", defaultPrefix = BindingConstants.LITERAL)
	@Property
	protected Integer height;

	/****
	 * 执行成功后的JS动作
	 */
	@Parameter(defaultPrefix = BindingConstants.LITERAL)
	@Property
	private String sucHandle;
	/****
	 * 执行保存前检查
	 */
	@Parameter(defaultPrefix = BindingConstants.LITERAL)
	@Property
	private String checkHandle;

	@Inject
	protected Request request;

	public Object getSaveLink() {
		Link link = resources.createEventLink("saveselectids");
		// 20230524 采用相对路径，https在绝对路径下会有问题
		return link.toURI();
	}

	StreamResponse onSaveselectids() {
		String ids = request.getParameter("ids");
		JSONArray idarry = new JSONArray(ids);
		String params = request.getParameter("params");
		JSONObject paramsObj = new JSONObject(params);

		Result retobj = null;
		CaptureResultCallback<Result> callback = new CaptureResultCallback<Result>();
		resources.triggerEvent(SymbolConstantsCus.EVENT_SAVESEL, new Object[] { idarry, paramsObj }, callback);
		if (callback.getResult() == null) {
			retobj = Result.getError("保存错误,请检查是否定义了保存事件");
			return TapestryAssist.getTextStreamResponse(retobj);
		}
		retobj = callback.getResult();
		final Messages mesparent = resources.getPage().getComponentResources().getMessages();
		String key = retobj.getExcept().getErrorCode();
		if (StringUtil.isNotNull(key) && mesparent.contains(key)) {
			retobj.setMessage(mesparent.get(key));
		}
		return TapestryAssist.getTextStreamResponse(retobj);
	}

}
