package net.wicp.tams.component.components;

import java.util.Date;

import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.AfterRender;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.InjectService;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.json.JSONObject;

import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.component.SymbolConstantsCus;
import net.wicp.tams.component.annotation.HtmlJs;
import net.wicp.tams.component.components.base.AbstractExtendableComponent;
import net.wicp.tams.component.encoder.DateEncoder;
import net.wicp.tams.component.services.ISupportedLocales;

/****
 * 日历控件
 * 
 * @author Administrator
 * 
 */
@HtmlJs(turl = { "/META-INF/assets/rjzjh/My97DatePicker/WdatePicker.js" })
public class DatePicker extends AbstractExtendableComponent {
	/*****
	 * 默认的起始日期为 1980-05-01，当日期框无论是何值,始终使用 1980-05-01 做为起始日期 。
	 * 使用动态参数(如:%y,%M分别表示当前年和月
	 * )，如：当年当月的1日,时分秒使用00:00:00作为起始时间示例为　{startDate:'%y-%M-01
	 * 00:00:00',dateFmt:'yyyy-MM-dd HH:mm:ss',alwaysUseStartDate:true}
	 */
	@Parameter(defaultPrefix = BindingConstants.LITERAL)
	private String startDate;
	/****
	 * 日期格式 yMdHmswW分别代表年月日时分秒星期周
	 */
	@Parameter(defaultPrefix = BindingConstants.LITERAL)
	private String dateFmt;

	@Inject
	@Symbol(SymbolConstantsCus.INPUT_WIDTH)
	private int inputWidth;

	/****
	 * 设置最大日期，支持动态日期，只能选择今天以前的日期(包括今天)：{maxDate:'%y-%M-%d'} %y 当前年 <br/>
	 * %M 当前月 <br/>
	 * %d 当前日 <br/>
	 * %ld 本月最后一天 <br/>
	 * %H 当前时 <br/>
	 * %m 当前分 <br/>
	 * %s 当前秒 <br/>
	 * {} 运算表达式,如:{%d+1}:表示明天 <br/>
	 * #F{} {}之间是函数可写自定义JS代码 <br/>
	 */
	@Parameter(defaultPrefix = BindingConstants.LITERAL)
	private String maxDate;

	/****
	 * 设置最小日期，支持动态日期，只能选择今天以后的日期(不包括今天)：{minDate:'%y-%M-{%d+1}'}
	 */
	@Parameter(defaultPrefix = BindingConstants.LITERAL)
	private String minDate;

	@InjectService("locales")
	protected ISupportedLocales supportedLocales;

	protected void writeFieldTag(MarkupWriter writer, final JSONObject params) {
		DateEncoder encoder = new DateEncoder();
		if (StringUtil.isNotNull(dateFmt)) {
			encoder = new DateEncoder(dateFmt);
		}
		String clientValue = "";
		if (value instanceof Date) {
			clientValue = encoder.toClient((Date) value);
		} else {
			clientValue = value == null ? "" : String.valueOf(value);
		}

		if (resources.isBound("startDate"))
			params.put("startDate", startDate);
		if (resources.isBound("dateFmt"))
			params.put("dateFmt", dateFmt);
		if (resources.isBound("maxDate"))
			params.put("maxDate", maxDate);
		if (resources.isBound("startDate"))
			params.put("minDate", minDate);
		if (!params.has("params")
				|| !params.getJSONObject("params").has("lang")) {// 如果没有显示地设置语言，则由组件自动判断
			params.put("lang", supportedLocales.getCurLocale().getLanguage());
		}
		if (params.has("params")) {
			for (String key_param : params.getJSONObject("params").keys()) {
				if (!params.has(key_param)) {// 如果　params域有而params域没有则要加到params中
					params.put(key_param,
							params.getJSONObject("params").get(key_param));
				}
			}
		}
		writer.element("input", "id", getClientId(), "class", "Wdate", "type",
				"text", "value", clientValue, "onfocus", "WdatePicker("
						+ params + ")");
	}

	@AfterRender
	void afterRender(MarkupWriter writer) {
		Element element = writer.getElement();
		String style = element.getAttribute("style");// 已有的样式
		// 合并样式。
		String widthStr = "width:" + inputWidth + "px";
		if (StringUtil.isNotNull(style)) {
			if (style.indexOf("width") < 0) {
				if (style.charAt(style.length() - 1) == ';') {
					style += widthStr;
				} else {
					style = style + ";" + widthStr;
				}
			}
		} else {
			style = widthStr;
		}
		element.forceAttributes("style", style);
		writer.end();
	}

}
