package net.wicp.tams.component.components;

import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.ioc.annotations.InjectService;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.javascript.InitializationPriority;

import net.wicp.tams.component.services.ISupportedLocales;

@Import(stack = "easyuistack")
public class DataGrid extends Panel {
	/***
	 * 取数据的地址
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	protected String url;
	/****
	 * 列定义
	 */
	@Parameter(required = true, defaultPrefix = BindingConstants.LITERAL)
	protected JSONArray columns;

	/****
	 * 直接给出下拉列表数据，如果此字段则url字段无效
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.PROP)
	protected JSONArray data;

	/***
	 * 自适应宽度，禁止出现横向滚动条
	 */
	@Parameter(required = false, value = "false", defaultPrefix = BindingConstants.LITERAL)
	private boolean fitColumns;
	
	/***
	 * 是否需要在init里Render（适用于非直接页面，如：layoutQuery）
	 */
	@Parameter(required = false, value = "false", defaultPrefix = BindingConstants.LITERAL)
	private boolean needInitRender;

	/***
	 * 是否只选择一行，默认为true
	 */
	@Parameter(required = false, value = "true", defaultPrefix = BindingConstants.LITERAL)
	private boolean singleSelect;

	/***
	 * 是否数据只显示在一行
	 */
	@Parameter(required = false, value = "false", defaultPrefix = BindingConstants.LITERAL)
	private boolean nowrap;

	/***
	 * 是否需要翻页
	 */
	@Parameter(required = false, value = "true", defaultPrefix = BindingConstants.LITERAL)
	private boolean pagination;

	@Parameter(required = false, value = "10", defaultPrefix = BindingConstants.LITERAL)
	private Integer pageSize;

	/***
	 * 排序的列名，默认为id字段
	 */
	@Parameter(required = false, value = "id", defaultPrefix = BindingConstants.LITERAL)
	private String sortName;

	/***
	 * 排序顺序,默认倒序
	 */
	@Parameter(required = false, value = "desc", defaultPrefix = BindingConstants.LITERAL)
	private String sortOrder;

	/****
	 * 列名为op所对应的函数，因为大部分都是只有一个列才需要个性化显示，相当于{field:
	 * 'op',width:150,title:'操作',formatter:function(value,row,index){}}这种写法，如果列名不为'op'的又需要个性化显示则用下列方
	 * 法 ： {field:'op2',width:110,title:'操作2',formatter:formatter2} 还需定义一个函数function
	 * formatter2(value,row,index){return index;}即可
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private String opFormatter;
	/*****
	 * gridLoad成功后执行
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private String loadSuccessHandle;

	/*****
	 * gridLoad 在load前执行
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private String beforeLoadHandle;

	@Override
	protected void writeFieldTag(MarkupWriter writer, final JSONObject spec) {
		packSpec(spec);

		writer.element("div", "id", getClientId());// 设置占位符
        //_datagridAdd而不是调用datagrid，datagrid在init方法调用
		if(resources.isBound("needInitRender")&&needInitRender) {//明确指明为在初始化阶段render
			javaScriptSupport.require("init") .invoke("datagridAdd") .priority(InitializationPriority.LATE).with(spec);//InitializationPriority.LATE不能解决问题
		}else {
			//InitializationPriority.LATE 在_initGlobal（页面的init方法）后面执行,而InitializationPriority.NORMAL是在_initGlobal前面执行的
			//_initGlobal方法里面有finxwith重新定位datagrid的长和宽，如果用LATE就会报错。
			javaScriptSupport.require("init") .invoke("datagrid").with(spec);//单独用Query页面，如checkpoint页面
		}
	}

	@InjectService("locales")
	protected ISupportedLocales supportedLocales;

	@Override
	protected void packSpec(final JSONObject spec) {
		super.packSpec(spec);// 父参数打包
		JSONObject params = spec.getJSONObject("params");
		if (resources.isBound("data")) {
			params.put("data", data);
		} else {
			params.put("url", supportedLocales.buildUrl(url));
		}
		params.put("fitColumns", fitColumns);
		params.put("singleSelect", singleSelect);
		params.put("nowrap", nowrap);
		params.put("pagination", pagination);
		params.put("pageSize", pageSize);
		params.put("sortName", sortName);
		params.put("sortOrder", sortOrder);
		params.put("rownumbers", false);

		if (resources.isBound("columns"))
			spec.put("columns", columns);// 把columns放到spec下，在js中需要处理它
		if (resources.isBound("opFormatter"))
			spec.put("opFormatter", opFormatter);
		if (resources.isBound("loadSuccessHandle"))
			spec.put("loadSuccessHandle", loadSuccessHandle);
		if (resources.isBound("beforeLoadHandle"))
			spec.put("beforeLoadHandle", beforeLoadHandle);
	}
}
