package net.wicp.tams.component.annotation;

import static org.apache.tapestry5.ioc.annotations.AnnotationUseContext.COMPONENT;
import static org.apache.tapestry5.ioc.annotations.AnnotationUseContext.PAGE;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.apache.tapestry5.ioc.annotations.UseWith;

import net.wicp.tams.component.constant.EasyUIAdd;

@Target({ ElementType.TYPE })
@Retention(RetentionPolicy.RUNTIME)
@Documented
@UseWith({ PAGE, COMPONENT })
public @interface HtmlJs {
	/****
	 * tapestry支持的地址
	 * 
	 * @return
	 */
	String[] turl() default {};

	/**
	 * 统一url
	 */
	String[] url() default {};

	/****
	 * easyui附加模块
	 */
	EasyUIAdd[] easyuiadd() default {};
}
