/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.component.services.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.callback.IConvertValue;
import net.wicp.tams.common.callback.impl.convertvalue.ConvertValueEnum;
import net.wicp.tams.common.constant.Encoding;
import net.wicp.tams.common.constant.PathType;
import net.wicp.tams.common.web.PageAssist;
import net.wicp.tams.component.services.IReq;
import net.wicp.tams.component.services.ISupportedLocales;
import net.wicp.tams.component.tools.TapestryAssist;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.tapestry5.commons.Messages;
import org.apache.tapestry5.http.services.Request;
import org.apache.tapestry5.http.services.RequestGlobals;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.InjectService;
import org.apache.tapestry5.ioc.annotations.Scope;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.upload.services.MultipartDecoder;
import org.apache.tapestry5.upload.services.UploadedFile;
import org.apache.tapestry5.util.TextStreamResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scope(value="perthread")
public class ReqImpl
implements IReq {
    private static final Logger log = LoggerFactory.getLogger(ReqImpl.class);
    private static final String paramName_allNum = "_findAllNum";
    @Inject
    private Messages messages;
    @Inject
    private MultipartDecoder decoder;
    @Inject
    private Request request;
    @Inject
    protected RequestGlobals requestGlobals;
    @Inject
    @Symbol(value="path.file.upload.dir")
    private String defaultUploadDir;
    @InjectService(value="locales")
    protected ISupportedLocales supportedLocales;
    private static String contextfilepath = null;
    private static File contextfileDir = null;
    private static File uploadDir = null;

    @Override
    public List<File> saveUpload(String uploadRelaPath) {
        String uploadPathTrue = IOUtil.mergeFolderAndFilePath((String)this.getUploadDir().getPath(), (String[])new String[]{uploadRelaPath});
        File uploadDirTrue = new File(uploadPathTrue);
        if (!uploadDirTrue.exists()) {
            try {
                FileUtils.forceMkdir((File)uploadDirTrue);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ArrayList<File> retList = new ArrayList<File>();
        List params = this.request.getParameterNames();
        Object[] fieldnames = this.request.getParameters("__uploadname__");
        if (ArrayUtils.isEmpty((Object[])fieldnames)) {
            return retList;
        }
        for (String param : params) {
            UploadedFile uploadedFile;
            if (!this.isContains((String[])fieldnames, param) || !StringUtil.isNotNull((Object)(uploadedFile = this.decoder.getFileUpload(param)).getFileName())) continue;
            log.info("\u4e0a\u4f20\u7684\u6587\u4ef6\uff1a{}", (Object)uploadedFile.getFileName());
            String filename = uploadedFile.getFileName().replace(" ", "");
            filename = filename.replace("(", "_").replace(")", "_");
            File copied = new File(uploadDirTrue, filename);
            uploadedFile.write(copied);
            retList.add(copied);
        }
        return retList;
    }

    private boolean isContains(String[] fieldnames, String param) {
        boolean isExit = false;
        for (String fieldname : fieldnames) {
            if (!param.startsWith(fieldname)) continue;
            isExit = true;
            break;
        }
        return isExit;
    }

    public List<String> uploadFile(Encoding oriEncoding) {
        ArrayList<String> retList = new ArrayList<String>();
        Object[] fieldnames = this.request.getParameters("__uploadname__");
        if (ArrayUtils.isEmpty((Object[])fieldnames)) {
            return retList;
        }
        List params = this.request.getParameterNames();
        for (String param : params) {
            if (!this.isContains((String[])fieldnames, param)) continue;
            UploadedFile uploadedFile = this.decoder.getFileUpload(param);
            log.info("\u4e0a\u4f20\u7684\u6587\u4ef6\uff1a{}", (Object)uploadedFile.getFileName());
            Encoding oriEncodingTrue = oriEncoding == null ? Encoding.UTF8 : oriEncoding;
            try {
                String slurp = IOUtil.slurp((InputStream)uploadedFile.getStream(), (Encoding)oriEncodingTrue);
                retList.add(slurp);
            }
            catch (IOException e) {
                log.error("\u4e0a\u4f20\u6587\u4ef6\uff1a{}\u5931\u8d25\u3002", (Object)uploadedFile.getFileName());
            }
        }
        return retList;
    }

    @Override
    public List<String> uploadFile() {
        return this.uploadFile(Encoding.UTF8);
    }

    @Override
    public List<File> saveUpload() {
        return this.saveUpload(null);
    }

    @Override
    public String getContextFilePath() {
        if (contextfilepath == null) {
            contextfilepath = this.requestGlobals.getHTTPServletRequest().getSession().getServletContext().getRealPath("/");
        }
        return contextfilepath;
    }

    @Override
    public File getContextDir() {
        if (contextfileDir == null && !(contextfileDir = new File(this.getContextFilePath())).exists()) {
            contextfileDir.mkdir();
        }
        return contextfileDir;
    }

    @Override
    public File getUploadDir() {
        String uploadDirPath = PathType.getPath((String)this.defaultUploadDir);
        if (uploadDir == null && !(uploadDir = new File(uploadDirPath)).exists()) {
            uploadDir.mkdir();
        }
        return uploadDir;
    }

    @Override
    public IConvertValue<String> getEnumConvert(Class entityClass) {
        return new ConvertValueEnum(entityClass, this.supportedLocales.getCurLocale().getLanguage());
    }

    @Override
    public PageAssist buildPage() {
        String page = this.request.getParameter("page");
        String rows = this.request.getParameter("rows");
        String allNumStr = this.request.getParameter(paramName_allNum);
        int pageNo = StringUtil.isNull((Object)page) ? 1 : Integer.parseInt(page);
        int rowsNum = StringUtil.isNull((Object)rows) ? 10 : Integer.parseInt(rows);
        int allNum = StringUtil.isNull((Object)allNumStr) ? -1 : Integer.parseInt(allNumStr);
        return new PageAssist(rowsNum, pageNo, allNum);
    }

    @Override
    public TextStreamResponse retSuccInfo() {
        return this.retSuccInfo(null);
    }

    @Override
    public TextStreamResponse retSuccInfo(String sucInfo) {
        Result retobj = Result.getSuc();
        sucInfo = StringUtil.isNull((Object)sucInfo) ? this.messages.get("common.hint.success") : (this.messages.contains(sucInfo) ? this.messages.get(sucInfo) : sucInfo);
        retobj.setMessage(sucInfo);
        return TapestryAssist.getTextStreamResponse(retobj);
    }

    @Override
    public TextStreamResponse retErrorInfo(String errmsg) {
        return TapestryAssist.getTextStreamResponse(Result.getError((String)errmsg));
    }
}

