package net.wicp.tams.component.services.impl;

import java.util.Locale;
import java.util.Map;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tapestry5.SymbolConstants;
import org.apache.tapestry5.commons.Messages;
import org.apache.tapestry5.http.services.Request;
import org.apache.tapestry5.http.services.RequestGlobals;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.PersistentLocale;

import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.ReflectAssist;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.callback.IConvertValue;
import net.wicp.tams.common.constant.StrPattern;
import net.wicp.tams.component.services.ISupportedLocales;

public class SupportedLocalesImpl implements ISupportedLocales {
	private String supportedLocales;
	@Inject
	private PersistentLocale persistentLocale;

	@Inject
	@Symbol(SymbolConstants.CONTEXT_PATH)
	private String contextPath;

	@Inject
	protected Request request;

	@Inject
	protected RequestGlobals requestGlobals;

	@Inject
	private Messages messages;// 国际化

	private final IConvertValue<String> I18NConvert = new IConvertValue<String>() {
		@Override
		public String getStr(String key) {
			if (StringUtil.isNull(key) || !messages.contains(key)) {
				return key;
			}
			return messages.get(key);
		}
	};

	public SupportedLocalesImpl(@Inject @Symbol("tapestry.supported-locales") String locales) {
		supportedLocales = locales;
	}

	public String getSupportedLocales() {
		return supportedLocales;
	}

	public void setLocale(String lang) {
		Locale local = new Locale(lang);
		persistentLocale.set(local);
	}

	public Locale getCurLocale() {
		if (persistentLocale.get() == null) {// 默认设置为中文
			persistentLocale.set(Locale.CHINESE);
		}
		return persistentLocale.get();
	}

	/****
	 * 构建国际化的URL，如果带有contextPath表示是绝对路径，无需加更多信息，
	 * 如果没有contextPath则需加上contextPath且加上国际化
	 */
	@Override
	public String buildUrl(String oriUrl) {
		//外部连接，如： http://localhost:8081/upload/0
		boolean isOuterLink = StrPattern.weburl.checkStrFormat(oriUrl);
		if (!isOuterLink) {
			String startStr = contextPath + "/" + getCurLocale().getLanguage();
			if (StringUtil.isNull(oriUrl)
					|| (StringUtils.isNotBlank(contextPath) && oriUrl.startsWith("/" + contextPath))
					|| oriUrl.startsWith(startStr)) {// contextPath不为空且地址以contextPath开始的路径不用操作，contextPath为空又是以/zh等开始
				return oriUrl;
			} else {
				String lanString = "/" + getCurLocale().getLanguage();
				if (oriUrl.startsWith("nolan:")) {
					lanString = "";
					oriUrl = oriUrl.replace("nolan:", "");
				}
				if (oriUrl.startsWith("/")) {
					return contextPath + lanString + oriUrl;
				} else {
					return contextPath + lanString + "/" + oriUrl;
				}

			}
		} else {//是外部连接
			return oriUrl;
		}
	}

	@Override
	public String buildUrlAbsolute(String oriUrl) {
		String pro = requestGlobals.getHTTPServletRequest().getProtocol().split("/")[0];
		String pre = String.format("%s://%s:%s", pro, requestGlobals.getRequest().getServerName(),
				requestGlobals.getRequest().getLocalPort());
		return IOUtil.mergeFolderAndFilePath(pre, buildUrl(oriUrl));
	}

	@Override
	public IConvertValue<String> getConvert() {
		return this.I18NConvert;
	}

	@Override
	public IConvertValue<Object> getConvert(final String colName) {
		return new IConvertValue<Object>() {
			@Override
			public String getStr(Object obj) {
				if (obj == null) {
					return "";
				}
				String key = "";
				try {
					if (ReflectAssist.isInterface(obj.getClass(), "java.util.Map")) {
						key = String.valueOf(((Map) obj).get(colName));
					} else {
						key = BeanUtils.getSimpleProperty(obj, colName);
					}
					if (messages.contains(key)) {
						return messages.get(key);
					} else {
						return key;
					}
				} catch (Exception e) {
					return key;
				}

			}
		};
	}
}
