package net.wicp.tams.component.services.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.tapestry5.commons.Messages;
import org.apache.tapestry5.http.services.Request;
import org.apache.tapestry5.http.services.RequestGlobals;
import org.apache.tapestry5.ioc.ScopeConstants;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.InjectService;
import org.apache.tapestry5.ioc.annotations.Scope;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.upload.services.MultipartDecoder;
import org.apache.tapestry5.upload.services.UploadedFile;
import org.apache.tapestry5.util.TextStreamResponse;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.callback.IConvertValue;
import net.wicp.tams.common.callback.impl.convertvalue.ConvertValueEnum;
import net.wicp.tams.common.constant.Encoding;
import net.wicp.tams.common.constant.PathType;
import net.wicp.tams.common.web.PageAssist;
import net.wicp.tams.component.SymbolConstantsCus;
import net.wicp.tams.component.components.Upload;
import net.wicp.tams.component.services.IReq;
import net.wicp.tams.component.services.ISupportedLocales;
import net.wicp.tams.component.tools.TapestryAssist;

@Scope(ScopeConstants.PERTHREAD)
@Slf4j
public class ReqImpl implements IReq {

	private static final String paramName_allNum = "_findAllNum";// 设置记录总数的
																	// json域名
	@Inject
	private Messages messages;// 国际化
	@Inject
	private MultipartDecoder decoder;
	@Inject
	private Request request;
	@Inject
	protected RequestGlobals requestGlobals;
	@Inject
	@Symbol(SymbolConstantsCus.PATH_FILE_UPLOAD_DIR)
	private String defaultUploadDir;// 默认的文件上传目录,在service里配置
	// @Inject
	// @Symbol(SymbolConstants.CONTEXT_PATH)
	// private String contextPath;// 默认的文件上传目录,在service里配置
	@InjectService("locales")
	protected ISupportedLocales supportedLocales;

	private static String contextfilepath = null;
	private static File contextfileDir = null;
	private static File uploadDir = null;// 默认的文件上传目录

	@Override
	public List<File> saveUpload(String uploadRelaPath) {
		String uploadPathTrue = IOUtil.mergeFolderAndFilePath(getUploadDir().getPath(), uploadRelaPath);
		File uploadDirTrue = new File(uploadPathTrue);
		if (!uploadDirTrue.exists()) {
			try {
				FileUtils.forceMkdir(uploadDirTrue);
			} catch (IOException e) {
			}
		}
		List<File> retList = new ArrayList<File>();
		List<String> params = request.getParameterNames();
		String[] fieldnames = request.getParameters(Upload.fixfieldname);
		if (ArrayUtils.isEmpty(fieldnames)) {
			return retList;
		}
		for (String param : params) {
			if (isContains(fieldnames, param)) {// 上传文件域
				UploadedFile uploadedFile = decoder.getFileUpload(param);
				if (StringUtil.isNotNull(uploadedFile.getFileName())) {// 没有选择文件
					log.info("上传的文件：{}", uploadedFile.getFileName());
					//规范文件名,1、去掉空格
					String filename = uploadedFile.getFileName().replace(" ", "");
					filename=filename.replace("(", "_").replace(")", "_");//()会导致在地址址栏中不能显示，（下载需要放地址址）
					File copied = new File(uploadDirTrue, filename);// 文件名
																						// agentid_随机数_fileName
					uploadedFile.write(copied);
					retList.add(copied);
				}
			}
		}
		return retList;
	}

	private boolean isContains(String[] fieldnames, String param) {
		boolean isExit = false;
		for (String fieldname : fieldnames) {
			if (param.startsWith(fieldname)) {
				isExit = true;
				break;
			}
		}
		return isExit;
	}

	public List<String> uploadFile(Encoding oriEncoding) {
		List<String> retList = new ArrayList<String>();
		String[] fieldnames = request.getParameters(Upload.fixfieldname);
		if (ArrayUtils.isEmpty(fieldnames)) {
			return retList;
		}
		List<String> params = request.getParameterNames();
		for (String param : params) {
			if (isContains(fieldnames, param)) {// 上传文件域
				UploadedFile uploadedFile = decoder.getFileUpload(param);
				log.info("上传的文件：{}", uploadedFile.getFileName());
				Encoding oriEncodingTrue = oriEncoding == null ? Encoding.UTF8 : oriEncoding;
				String slurp;
				try {
					slurp = IOUtil.slurp(uploadedFile.getStream(), oriEncodingTrue);
					retList.add(slurp);
				} catch (IOException e) {
					log.error("上传文件：{}失败。", uploadedFile.getFileName());
				}
			}
		}
		return retList;
	}

	public List<String> uploadFile() {
		return uploadFile(Encoding.UTF8);
	}

	@Override
	public List<File> saveUpload() {
		return saveUpload(null);
	}
//由于转为springboot了，所以context没什么用了
//	@Override
//	public List<File> saveUploadContext(String uploadPathFromContext) {
//		File toDir = StringUtil.isNull(uploadPathFromContext) ? contextfileDir
//				: new File(contextfilepath, uploadPathFromContext);
//		if (!toDir.exists()) {
//			toDir.mkdir();
//		}
//		return saveUpload(toDir);
//	}

	@Override
	public String getContextFilePath() {
		if (contextfilepath == null) {
			contextfilepath = requestGlobals.getHTTPServletRequest().getSession().getServletContext().getRealPath("/");
		}
		return contextfilepath;
	}

	@Override
	public File getContextDir() {
		if (contextfileDir == null) {
			contextfileDir = new File(getContextFilePath());
			if (!contextfileDir.exists()) {
				contextfileDir.mkdir();
			}
		}
		return contextfileDir;
	}

	@Override
	public File getUploadDir() {
		// String uploadDirPath = getContextFilePath() + File.separator +
		// defaultUploadDir;
		String uploadDirPath = PathType.getPath(defaultUploadDir);
		if (uploadDir == null) {
			uploadDir = new File(uploadDirPath);
			if (!uploadDir.exists()) {
				uploadDir.mkdir();
			}
		}
		return uploadDir;
	}

	@SuppressWarnings("rawtypes")
	@Override
	public IConvertValue<String> getEnumConvert(Class entityClass) {
		return new ConvertValueEnum(entityClass, supportedLocales.getCurLocale().getLanguage());
	}

	@Override
	public PageAssist buildPage() {
		String page = request.getParameter("page");
		String rows = request.getParameter("rows");
		String allNumStr = request.getParameter(paramName_allNum);
		int pageNo = StringUtil.isNull(page) ? 1 : Integer.parseInt(page);
		int rowsNum = StringUtil.isNull(rows) ? 10 : Integer.parseInt(rows);
		int allNum = StringUtil.isNull(allNumStr) ? -1 : Integer.parseInt(allNumStr);
		return new PageAssist(rowsNum, pageNo, allNum);
	}

	@Override
	public TextStreamResponse retSuccInfo() {
		return retSuccInfo(null);
	}

	@Override
	public TextStreamResponse retSuccInfo(String sucInfo) {
		Result retobj = Result.getSuc();
		sucInfo = StringUtil.isNull(sucInfo) ? messages.get("common.hint.success")
				: (messages.contains(sucInfo) ? messages.get(sucInfo) : sucInfo);
		retobj.setMessage(sucInfo);
		return TapestryAssist.getTextStreamResponse(retobj);
	}

	@Override
	public TextStreamResponse retErrorInfo(String errmsg) {
		return TapestryAssist.getTextStreamResponse(Result.getError(errmsg));
	}
}
