package net.wicp.tams.component.pages;

import java.util.List;

import org.apache.commons.lang3.tuple.Pair;
import org.apache.tapestry5.annotations.BeforeRenderTemplate;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.http.services.Request;
import org.apache.tapestry5.util.TextStreamResponse;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import cn.hutool.core.bean.BeanUtil;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.ReflectAssist;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.json.EasyUiAssist;
import net.wicp.tams.common.apiext.json.JSONUtil;
import net.wicp.tams.common.beans.QueryAssetInfo;
import net.wicp.tams.component.tools.TapestryAssist;

/***
 * 只有接入了mybatisplus的项目才能使用
 * 
 * @author Andy
 *
 * @param <T>
 */
public abstract class ParentPageBeanMyBatis<T> extends ParentPageBean<T> {

	////////////////////////////////////////////////////////////// mytatis特有的/////////////////////////////////////////////////////////////////////////////////

	public abstract BaseMapper<T> getBaseMapper();

	public abstract void packageQuery(T t, String parentId, QueryWrapper<T> queryWrapper);

	public TextStreamResponse onQuery() {
		T t = null;
		//不加前面的类型检查，paramsBean会抛异常，会导致查询的combogrid出不来下拉列表
		if (paramsBean.getClass().getName().equals(getTClass().getName()) && paramsBeanExists) {
			t = paramsBean;// paramsBeanExists ? paramsBean : TapestryAssist.getBeanFromPage(getTClass(),
							// requestGlobals);
			paramsBean = null;//session对象，不影响t的引用
		} else {
			t = TapestryAssist.getBeanFromPage(getTClass(), requestGlobals);
		}
		QueryWrapper<T> queryWrapper = new QueryWrapper<T>();
		
		// 适用于级联查询。
		final String parentId = request.getParameterNames().contains("parent") ? request.getParameter("parent") : null;
		try {
			this.packageQuery(t, parentId, queryWrapper);// 组装查询
		} catch (Throwable e) {
			// 抛异常就是需要阻止查询
			return TapestryAssist.getTextStreamResponse(EasyUiAssist.getJsonForGridEmpty());
		}
		BaseMapper<T> mapper = getBaseMapper();
		String needpage = request.getParameter("needpage");
		boolean isPage = StringUtil.isNotNull(needpage) && !Boolean.parseBoolean(needpage) ? false : true;
		Pair<List<T>, Long> query = this.query(mapper, queryWrapper, isPage);
		// Pair<List<SysUser>, Long> query = doQuery(t, queryWrapper);
		QueryAssetInfo queryAssetInfo = queryAssetInfo();
		String retstr = EasyUiAssist.getJsonForGridAlias2(query.getLeft(), queryAssetInfo.getConvertTitle(),
				queryAssetInfo.getConvertMap(), query.getRight(), queryAssetInfo.getJsonCols(),
				queryAssetInfo.getBase64Cols(), queryAssetInfo.getExcludeFields());
		return TapestryAssist.getTextStreamResponse(retstr);
	}
	
	


	/***
	 * 用于级联或查询为combobox，它查询更轻量，不需要convertValue转换器
	 * 
	 * @return
	 */
	public TextStreamResponse onQueryList() {
		final T t = TapestryAssist.getBeanFromPage(getTClass(), requestGlobals);
		QueryWrapper<T> queryWrapper = new QueryWrapper<T>();
		List<String> parameterNames = request.getParameterNames();
		// 适用于级联查询。
		final String parentId = parameterNames.contains("parent") ? request.getParameter("parent") : null;
		if (parentId != null && StringUtil.isNull(parentId)) {// 有传入parent参数,但parent参数为空
			return TapestryAssist.getTextStreamResponse(JSONUtil.getJsonForListEmpty());
		}
		final String valueColName = parameterNames.contains("value") ? request.getParameter("value") : "id";
		final String textColName = parameterNames.contains("text") ? request.getParameter("text") : "name";
		this.packageQuery(t, parentId, queryWrapper);// 组装查询
		BaseMapper<T> mapper = getBaseMapper();
		Pair<List<T>, Long> query = this.query(mapper, queryWrapper, false);
		String comboboxStr = JSONUtil.getJsonForCombobox(query.getLeft(), textColName, valueColName);
		return TapestryAssist.getTextStreamResponse(comboboxStr);
	}

	/***
	 * mybatis查询封装
	 * 
	 * @param <T>          mybatis的po
	 * @param mapper       mybatis的mapper
	 * @param queryWrapper mybatis的查询封装
	 * @param isPage       是否需要翻页
	 * @return L：数据，R:数据的总量
	 */
	@SuppressWarnings("hiding")
	public <T> Pair<List<T>, Long> query(BaseMapper<T> mapper, QueryWrapper<T> queryWrapper, boolean isPage) {
		List<T> selectList = null;
		long size = 0;
		if (isPage) {// 需要分页，默认
			Page<T> selectPage = mapper.selectPage(ParentPageBeanMyBatis.buildPage(request), queryWrapper);
			selectList = selectPage.getRecords();
			size = selectPage.getTotal();
		} else {
			selectList = mapper.selectList(queryWrapper);
			size = selectList.size();
		}
		return Pair.of(selectList, size);
	}

	/***
	 * 保存或修改对象
	 * 
	 * @param mapper
	 * @param callback
	 * @return
	 */
	public TextStreamResponse saveCommon(BaseMapper<T> mapper, IUpdateObj<T> callback) {
		final T po = TapestryAssist.getBeanFromPage(getTClass(), requestGlobals);
		if (callback != null) {
			callback.doUpdate(po, BeanUtil.getFieldValue(po, "id") == null);
		}
		if (BeanUtil.getFieldValue(po, "id") == null) {
			mapper.insert(po);
		} else {
			ReflectAssist.invokeMothed(mapper, "updateByPrimaryKeySelective", po);
		}
		return TapestryAssist.getTextStreamResponse(Result.getSuc());
	}

	public TextStreamResponse saveCommon(BaseMapper<T> mapper) {
		return saveCommon(mapper, null);
	}

	protected interface IUpdateObj<V> {
		public void doUpdate(V po, boolean isInsert);
	}

	// 页面传过来的初始化参数，由于grid设置了url后会，render时初始会执行一次不带参数的查询，这样就没办法过滤带初始化参数的数据了。所以需要做些被救措施
	@SessionState
	private T paramsBean;

	private boolean paramsBeanExists;

	@BeforeRenderTemplate
	private void initRecord() {
		T beanFromPage = TapestryAssist.getBeanFromPage(getTClass(), requestGlobals);
		this.paramsBean = beanFromPage;
	}

	////////////////////////////////////////////////////////// 配合common-jdbc一起使用/////////////////////////////////////////////////////////////////////////////////////////////////////

	public static <T> Page<T> buildPage(Request request) {
		int page = request.getParameterNames().contains("page") ? Integer.parseInt(request.getParameter("page")) : 1;
		int rows = request.getParameterNames().contains("rows") ? Integer.parseInt(request.getParameter("rows")) : 10;
		return new Page<T>(page, rows);
	}

}
