package net.wicp.tams.component.components;

import org.apache.tapestry5.Asset;
import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.AfterRenderTemplate;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Path;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.commons.Messages;
import org.apache.tapestry5.http.Link;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.InjectService;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.constant.PathType;
import net.wicp.tams.component.SymbolConstantsCus;
import net.wicp.tams.component.assistbean.FilesBean;
import net.wicp.tams.component.services.ISupportedLocales;
import net.wicp.tams.component.tools.TapestryAssist;

/****
 * 文件上传组件,可以支持多个文件的上传,可以显示已上传的多个文件
 * 
 * @author 周俊辉
 * 
 */
public class Upload {
	public static final String prefix = "rjzjhuploadfield";// 上传的文件域
	public static final String prefix_exit = "rjzjhexistfield";// 存在的文件隐藏域Name
	public static final String fixfieldname = "__uploadname__";// 标识上传文件的域的name值，固定的名字

	public String getFixfieldname() {
		return fixfieldname;
	}

	@Inject
	@Path("${path.comassets}/images/add.png")
	@Property
	private Asset addImg;

	@Inject
	@Path("${path.comassets}/images/del.png")
	@Property
	private Asset delImg;
	@InjectService("locales")
	protected ISupportedLocales supportedLocales;
	@Inject
	protected JavaScriptSupport support;
	@Inject
	protected ComponentResources resources;
	@Inject
	protected Messages messages;// 国际化

	/*
	 * @Parameter(value = "prop:componentResources.id", defaultPrefix =
	 * BindingConstants.LITERAL) private String id;
	 */
	@Parameter(defaultPrefix = BindingConstants.LITERAL)
	private String id;

	@Parameter(defaultPrefix = BindingConstants.LITERAL)
	private String name;

	@Environmental
	protected JavaScriptSupport javaScriptSupport;

	@Inject
	private AssetSource assetSource;

	/***
	 * 是否支持多个文件
	 */
	@Parameter(value = "false", defaultPrefix = BindingConstants.LITERAL)
	@Property
	private boolean multi;
	/***
	 * 初始文件地址,多个用","号分隔
	 */
	@Parameter(defaultPrefix = BindingConstants.LITERAL)
	private String initfile;

	public String getFiletag() {
		return prefix;
	}

	public FilesBean[] getInitFiles() {
		if (resources.isBound("initfile") && StringUtil.isNotNull(initfile)) {
			String[] fileStrs = initfile.split(",");
			FilesBean[] rets = new FilesBean[fileStrs.length];
			for (int i = 0; i < fileStrs.length; i++) {
				FilesBean temp = new FilesBean();
				temp.setFileName(fileStrs[i]);
				temp.setPath(IOUtil.mergeFolderAndFilePath(uploadDir, fileStrs[i]));
				temp.setDownLink(getUploadFileLink(fileStrs[i]).toURI());
				rets[i] = temp;
			}
			return rets;
		}
		return new FilesBean[0];
	}

	public StreamResponse onUploadFile(final String filePath) {
		// String filePathTrue=new String(filePath.getBytes("iso8859-1"),"UTF-8");
		// String filePathTrue = URLDecoder.decode(filePath,"UTF-8");
		return TapestryAssist.getFileStreamResponse(uploadDir, filePath);
	}

	public Link getUploadFileLink(String filePath) {
		return resources.createEventLink("uploadFile", filePath);
	}

	/***
	 * 返回前台做为js的url变量
	 * 
	 * @return
	 */
	public String getUploadFileUrl() {
		String retcurl = resources.createEventLink("uploadFile").toURI();
		return retcurl;
	}

	@Property
	private FilesBean initFile = new FilesBean();// 不创建会有异常
	@Property
	private int index;

	public String getInitFileId() {
		return getId() + index;
	}

	@Inject
	@Symbol(SymbolConstantsCus.PATH_FILE_UPLOAD_DIR)
	private String defaultUploadDir;// 默认的文件上传目录,在service里配置

	/***
	 * 初始文件地址,多个用","号分隔
	 */
	@Parameter(defaultPrefix = BindingConstants.LITERAL)
	@Property
	private String uploadDir = PathType.getPath(defaultUploadDir);

	@AfterRenderTemplate
	void afterRenderTemplate() {
		JSONObject spec = new JSONObject();
		spec.put("id", getId() + "_file");// 注意与页面上的file组件的id一致
		spec.put("delImg", delImg.toString());
		spec.put("prefix", getNameFile());
		javaScriptSupport.require("init").invoke("uploadBind").with(spec);
	}

	/****
	 * 得到name属性
	 * 
	 * @return
	 */
	public String getName() {
		if (multi) {// 如果是多个则name参数无效.
			return prefix;
		} else {
			if (!resources.isBound("name")) {
				return prefix;
			} else {
				return this.name;
			}
		}
	}

	// 文件上传域，就是在存储值的field域加上"_file"
	public String getNameFile() {
		return getName() + "_file";
	}

	/***
	 * 得到id
	 * 
	 * @return
	 */
	public String getId() {
		if (!resources.isBound("id") && StringUtil.isNull(id)) {
			id = support.allocateClientId(resources);
		}
		return this.id;
	}
}
