package net.wicp.tams.component.components;

import java.util.List;

import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.Events;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SetupRender;
import org.apache.tapestry5.http.Link;
import org.apache.tapestry5.http.services.Request;
import org.apache.tapestry5.internal.util.CaptureResultCallback;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.util.TextStreamResponse;

import net.wicp.tams.common.Result;
import net.wicp.tams.component.SymbolConstantsCus;
import net.wicp.tams.component.assistbean.HighchartsBean;
import net.wicp.tams.component.components.base.BaseProjectComponent;
import net.wicp.tams.component.tools.TapestryAssist;

/***
 * treegrid选择器(左边是treegrid，右边自定义)
 * 
 * @author andy.zhou
 *
 */
@Events({ SymbolConstantsCus.EVENT_SELTREEGRID_CREATEROOT })
public class SelTreeGrid extends BaseProjectComponent {

	/**
	 * 没有根节点时创建
	 */
	@Parameter(required = false, value = "根节点", defaultPrefix = BindingConstants.LITERAL)
	@Property
	private String noroottitle;

	/****
	 * 组件宽度。 类型：整型
	 */
	@Parameter(defaultPrefix = BindingConstants.LITERAL)
	@Property
	protected Integer width;

	/***
	 * 左边树的宽度
	 */
	@Parameter(value = "250", defaultPrefix = BindingConstants.LITERAL)
	@Property
	protected Integer widthleft;
	/****
	 * 组件高度。 类型：整型
	 */
	@Parameter(value = "400", defaultPrefix = BindingConstants.LITERAL)
	@Property
	protected Integer height;

	/****
	 * 列定义
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private JSONArray columns;

	public JSONArray getColumns() {
		if (!resources.isBound("columns") || columns == null || columns.size() == 0) {
			JSONArray retobj = new JSONArray("[[{field:'text',width:100,title:'text'}]]");
			return retobj;
		} else {
			return columns;
		}
	}

	/***
	 * id
	 */
	@Parameter(required = false, value = "id", defaultPrefix = BindingConstants.LITERAL)
	@Property
	private String idField;
	/***
	 * text
	 */
	@Parameter(required = false, value = "text", defaultPrefix = BindingConstants.LITERAL)
	@Property
	private String treeField;

	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	@Property
	private JSONArray data;

	@Parameter(required = false, value = "{}", defaultPrefix = BindingConstants.LITERAL)
	private JSONObject params;// 其它附加参数

	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	@Property
	private String dbClickHandle;

	public JSONObject getParams() {
		if (!resources.isBound("params") || params == null) {
			params = new JSONObject();
		}
		if (resources.isBound("dbClickHandle")) {
			params.put("onDblClickRow", dbClickHandle);
		}
		// if(!params.has("onDblClickRow")){
		// params.put("onDblClickRow",
		// "function(row){require([\"component/rjzjh/seltreegrid\"], function(sel) {
		// sel.dbclickrow('"+getId()+"',row);});}");
		// }
		return params;
	}

	@Inject
	protected ComponentResources resources;

	/***
	 * 是否有组织树
	 * 
	 * @return
	 */
	public boolean isEmptyOrg() {
		return data == null || data.size() == 0;
	}

	private void queryCharts(JSONObject param) {

	}

	@Property
	private String createUrl;

	@SetupRender
	void initializeValues() {
		Link link = resources.createEventLink("treeCreate");
		this.createUrl = link.getBasePath();// 示例/zh/cas/usermanager.comboboxuser:queryuser
	}

	@Inject
	protected Request request;

	TextStreamResponse onTreeCreate() {
		String rootName = request.getParameter("rootName");
		CaptureResultCallback<Result> callback = new CaptureResultCallback<Result>();
		resources.triggerEvent(SymbolConstantsCus.EVENT_SELTREEGRID_CREATEROOT, new Object[] { rootName }, callback);
		return TapestryAssist.getTextStreamResponse(callback.getResult());
	}

	/*
	 * @SetupRender void addPageEle(MarkupWriter writer) {
	 * //writer.getDocument().getRootElement().find("body").attribute("class",
	 * "easyui-layout"); }
	 */
}
