package net.wicp.tams.component.components;

import java.util.Locale;

import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.AfterRender;
import org.apache.tapestry5.annotations.BeforeRenderBody;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Events;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.http.Link;
import org.apache.tapestry5.http.services.Request;
import org.apache.tapestry5.internal.util.CaptureResultCallback;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.PageRenderLinkSource;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.component.SymbolConstantsCus;
import net.wicp.tams.component.components.base.AbstractExtendableComponent;
import net.wicp.tams.component.services.ISupportedLocales;

/****
 * 语言选择组件
 *
 * @author Andy.zhou
 *
 */
@Events({ SymbolConstantsCus.EVENT_CHANGELOCALE })
public class SelLocale extends AbstractExtendableComponent {
	@Inject
	protected ISupportedLocales supportedLocales;

	@Parameter(defaultPrefix = "literal", required = false)
	private String suplan;

	@Inject
	protected Request request;
	@Environmental
	protected JavaScriptSupport javaScriptSupport;

	@Override
	protected void writeFieldTag(MarkupWriter writer, JSONObject spec) {
		javaScriptSupport.require("component/rjzjh/sellang");
		Link link = resources.createEventLink("changLang");
		Element element = writer.element("select", "id", getClientId(),
				"value", supportedLocales.getCurLocale().getLanguage(),
				"lang-change-select", "true", "chang-lang-url",
				link.toAbsoluteURI());
		if (!resources.isBound("supportedLocales")) {
			suplan = supportedLocales.getSupportedLocales();
		}
		if (StringUtil.isNotNull(suplan)) {
			String[] locals = suplan.split(",");
			for (int i = 0; i < locals.length; i++) {
				String local = locals[i];
				Locale locale = new Locale(local);
				Element optElement = element.element("option", "value",
						locale.getLanguage());
				if (locale.getLanguage().equals(
						supportedLocales.getCurLocale().getLanguage())) {
					optElement = optElement.attribute("selected", "true");
				}
				optElement.cdata(locale.getDisplayName(locale));
			}
		}
	}

	@Inject
	private PageRenderLinkSource linkSource;

	/***
	 *
	 */
	JSONObject onChangLang() {
		String lang = request.getParameter("lang");
		supportedLocales.setLocale(lang);
		Link link = linkSource.createPageRenderLink(resources.getPageName());

		// 触发客户定义好的语言选择事件
		CaptureResultCallback<Result> callback = new CaptureResultCallback<Result>();
		resources.triggerEvent(SymbolConstantsCus.EVENT_CHANGELOCALE,
				new Object[] { lang }, callback);

		return new JSONObject("url", link.toAbsoluteURI());
	}

	@BeforeRenderBody
	private boolean rendbody() {
		return false;
	}

	@AfterRender
	protected final void afterRender(MarkupWriter writer) {
		writer.end();
	}
}
