package net.wicp.tams.component.components;

import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.AfterRenderTemplate;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.commons.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;

import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.callback.impl.convertvalue.ConvertValueEasyUIGrid;

@Import(stylesheet = { "${path.codemirror}/addon/hint/show-hint.css" }, stack = "codemirror")
public class SQL {
	@Inject
	private JavaScriptSupport support;
	@Inject
	private ComponentResources resources;
	@Inject
	private Messages messages;// 国际化

	@Parameter(defaultPrefix = BindingConstants.LITERAL)
	private String id;

	@Parameter(defaultPrefix = BindingConstants.LITERAL)
	@Property
	private String name;

	@Parameter(defaultPrefix = BindingConstants.LITERAL)
	private String value;// 初始值

	// 得到表与字段的映射关系
	@Parameter(defaultPrefix = BindingConstants.LITERAL, required = false)
	private String tableToColumnsUrl;//

	@AfterRenderTemplate
	void afterRenderTemplate() {
		JSONObject spec = new JSONObject();
		spec.put("id", getId());// 注意与页面上的file组件的id一致
		if (resources.isBound("value")) {
			spec.put("value", value);
		}
		if (resources.isBound("tableToColumnsUrl") && StringUtil.isNotNull(tableToColumnsUrl)) {
			String result = ConvertValueEasyUIGrid.callUrlByTenant(
					IOUtil.mergeFolderAndFilePath(Conf.get("common.apiext.context"), tableToColumnsUrl));
			com.alibaba.fastjson.JSONObject hint = JSON.parseObject(result);
			String hintstr = JSON.toJSONString(hint, SerializerFeature.UseSingleQuotes);
			spec.put("hint", hintstr);
		} else {
			spec.put("hint", "{}");
		}
		support.require("init").invoke("sql").with(spec);
	}

	/***
	 * 得到id
	 * 
	 * @return
	 */
	public String getId() {
		if (!resources.isBound("id") && StringUtil.isNull(id)) {
			id = support.allocateClientId(resources);
		}
		return this.id;
	}
}
