package net.wicp.tams.component.components;

import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.ioc.annotations.InjectService;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.component.services.ISupportedLocales;

@Import(stack = "easyuistack")
public class Propertygrid extends DataGrid {

	@Parameter(required = false, value = "true", defaultPrefix = BindingConstants.LITERAL)
	private Boolean showGroup;

	@Parameter(required = false, value = "false", defaultPrefix = BindingConstants.LITERAL)
	private String name;

	@Parameter(required = false, value = "false", defaultPrefix = BindingConstants.LITERAL)
	private String parent;

	/***
	 * 按钮栏,json
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private String toolbar;

	@Override
	protected void writeFieldTag(MarkupWriter writer, final org.apache.tapestry5.json.JSONObject spec) {
		packSpec(spec);
		writer.element("div", "id", getClientId());// 设置占位符
		javaScriptSupport.require("init").invoke("propertygrid").with(spec);
	}

	@InjectService("locales")
	protected ISupportedLocales supportedLocales;

	@Override
	protected void packSpec(final org.apache.tapestry5.json.JSONObject spec) {
		// super.packSpec(spec);// 不用打包父参数打包
		if (resources.isBound("name")) {
			spec.put("name", name);
		} else {
			spec.put("name", getClientId());
		}
		if (resources.isBound("parent") && StringUtil.isNotNull(parent)) {
			spec.put("parent", parent);
		}
		org.apache.tapestry5.json.JSONObject params = spec.getJSONObject("params");
		params.put("showGroup", showGroup);
		params.put("scrollbarSize", 0);
		if (resources.isBound("data")) {
			params.put("data", data);
		} else {
			params.put("url", supportedLocales.buildUrl(url));
		}
		if (resources.isBound("columns")) {
			params.put("columns", columns);
		}
		if (resources.isBound("toolbar") && StringUtil.isNotNull(toolbar)) {
			JSONArray array = JSONArray.parseArray(toolbar);
			StringBuffer buff = new StringBuffer();
			 //JSON.DEFAULT_GENERATE_FEATURE =  SerializerFeature.config( JSON.DEFAULT_GENERATE_FEATURE,SerializerFeature.QuoteFieldNames , false);
			//params.put("toolbar", "[{iconCls: 'icon-edit',text:'aaaaa',align:'center',handler: function(){alert('edit')}},'-',{iconCls: 'icon-help',align:'right',handler: function(){alert('help')}}]");
			//                       [{handler:'function(){alert(1)}',iconCls:'icon-edit'}]
			for (Object object : array) {
				buff.append(",{");
				JSONObject obj=(JSONObject)object;
				for (String key : obj.keySet()) {
					if("handler".equals(key)) {
						buff.append(String.format("%s:%s,", key,obj.getString(key)));
					}else {
						buff.append(String.format("%s:'%s',", key,obj.getString(key)));
					}
				}
				buff.deleteCharAt(buff.length()-1);
				buff.append("}");
				//buff.append(JSONObject.toJSONString(object));
				//buff.append(",'-'");
			}
			String toolbarstr = buff.length() > 0 ? buff.substring(1) : buff.toString();
			params.put("toolbar", "["+toolbarstr+"]");
		}
	}
}
